/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.image.controller;

import com.qianjiang.image.bean.InfoImageClassify;
import com.qianjiang.image.service.InfoImageClassifyService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InfoImageClassifyController {
    private static final MyLogger LOGGER = new MyLogger(InfoImageClassifyController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYIMAGECLASSIFYBYPB_HTM = "queryImageClassifyByPb.htm?CSRFToken=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private InfoImageClassifyService infoImageClassifyService;
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryImageClassifyByPb"})
    public ModelAndView queryImageClassifyByPb(PageBean pb) {
        LOGGER.debug("======\u5206\u9875\u67e5\u8be2\u56fe\u7247\u5206\u7c7b======");
        return new ModelAndView("jsp/infoImage/infoImageClassify");
    }

    @ResponseBody
    @RequestMapping(value={"/queryImageClassifyByPbForAjax"}, produces={"application/json;charset=UTF-8"})
    public PageBean queryImageClassifyByPbForAjax(PageBean pb, HttpServletRequest request) {
        LOGGER.debug("======\u5206\u9875\u67e5\u8be2\u56fe\u7247\u5206\u7c7b======");
        if (request.getSession().getAttribute("menuId") != null) {
            pb.setPageSize(10000);
        }
        return this.infoImageClassifyService.selectImageClassifyByParam(pb);
    }

    @ResponseBody
    @RequestMapping(value={"/queryAllImageClassifyForAjax"}, produces={"application/json;charset=UTF-8"})
    public List<InfoImageClassify> queryAllImageClassifyForAjax() {
        LOGGER.debug("======Ajax\u67e5\u8be2\u6240\u6709\u56fe\u7247\u5206\u7c7b======");
        return this.infoImageClassifyService.selectAllImageClassify();
    }

    @ResponseBody
    @RequestMapping(value={"/queryAllImageClassifyForImg"}, produces={"application/json;charset=UTF-8"})
    public List<InfoImageClassify> queryAllImageClassifyForImg() {
        LOGGER.debug("======Ajax\u67e5\u8be2\u6240\u6709\u56fe\u7247\u5206\u7c7b======");
        return this.infoImageClassifyService.selectAllImageClassifyForImg();
    }

    @RequestMapping(value={"/saveImageClassifyAction"})
    public ModelAndView saveImageClassifyAction(@Valid InfoImageClassify infoImageClassify, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYIMAGECLASSIFYBYPB_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u6dfb\u52a0\u56fe\u7247\u5206\u7c7b======");
        this.infoImageClassifyService.saveInfoImageClassify(infoImageClassify);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u56fe\u7247\u5206\u7c7b", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGECLASSIFYBYPB_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateImageClassifyAction"})
    public ModelAndView updateImageClassifyAction(@Valid InfoImageClassify infoImageClassify, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYIMAGECLASSIFYBYPB_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u4fee\u6539\u56fe\u7247\u5206\u7c7b======");
        this.infoImageClassifyService.updateInfoImageClassify(infoImageClassify);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u56fe\u7247\u5206\u7c7b", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGECLASSIFYBYPB_HTM + request.getParameter("CSRFToken")));
    }

    @ResponseBody
    @RequestMapping(value={"/checkDeleteClassify"}, produces={"application/json;charset=UTF-8"})
    public boolean checkDeleteClassify(Long infoImageClassifyId) {
        LOGGER.debug("======Ajax\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u4fe1\u606f\u6570\u91cf\uff0c\u5224\u65ad\u662f\u5426\u80fd\u5220\u9664======");
        boolean flag = false;
        List list = this.infoImageClassifyService.selectByParentId(infoImageClassifyId);
        if (null != list && !list.isEmpty()) {
            flag = false;
        } else {
            int count = this.infoImageManageService.selectImageManageCountByClassifyId(infoImageClassifyId);
            LOGGER.debug("======" + count + "======");
            flag = count <= 0;
        }
        return flag;
    }

    @RequestMapping(value={"/deleteImageClassifyAction"})
    public ModelAndView deleteImageClassifyAction(Long infoImageClassifyId, HttpServletRequest request) {
        LOGGER.debug("======\u5220\u9664\u56fe\u7247\u5206\u7c7b======");
        this.infoImageClassifyService.deleteInfoImageClassify(infoImageClassifyId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u56fe\u7247\u5206\u7c7b", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGECLASSIFYBYPB_HTM + request.getParameter("CSRFToken")));
    }

    public InfoImageClassifyService getInfoImageClassifyService() {
        return this.infoImageClassifyService;
    }

    @Resource(name="InfoImageClassifyService")
    public void setInfoImageClassifyService(InfoImageClassifyService infoImageClassifyService) {
        this.infoImageClassifyService = infoImageClassifyService;
    }

    public InfoImageManageService getInfoImageManageService() {
        return this.infoImageManageService;
    }

    @Resource(name="InfoImageManageService")
    public void setInfoImageManageService(InfoImageManageService infoImageManageService) {
        this.infoImageManageService = infoImageManageService;
    }
}

