/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.auth.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.third.auth.bean.ThirdAuthority;
import com.qianjiang.third.auth.bean.ThirdPage;
import com.qianjiang.third.auth.service.ThirdAuthorityPageService;
import com.qianjiang.third.auth.service.ThirdAuthorityService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ThirdManagerController {
    private static final MyLogger LOGGER = new MyLogger(ThirdManagerController.class);
    @Resource(name="thirdAuthorityPageService")
    private ThirdAuthorityPageService thirdManagerService;
    @Resource(name="thirdAuthorityService")
    private ThirdAuthorityService thirdAuthorityService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;

    @RequestMapping(value={"/loadthirdpage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ThirdPage> loadThirdPage(HttpServletRequest request, Long cid) {
        List menus = (List)request.getSession().getAttribute("menuPages");
        if ((menus == null || menus.size() < 1) && (menus = this.thirdManagerService.queryMenuByManager(cid)) != null && menus.size() > 0) {
            request.getSession().setAttribute("menuPages", (Object)menus);
        }
        return menus;
    }

    @RequestMapping(value={"third/loadallauthority"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> loadAllAuthority(HttpServletRequest request, Long pid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("pages", this.thirdManagerService.loadAllAuthority());
        resultMap.put("rolePages", this.thirdManagerService.queryThirdPageByAuthId(pid));
        return resultMap;
    }

    @RequestMapping(value={"/updateauthority"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateAuthority(HttpServletRequest request, String[] pagesId, Long authId) {
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        ThirdAuthority authority = this.thirdAuthorityService.selectAuthorById(authId);
        if (authority != null) {
            if (thirdId.equals(authority.getStoreId())) {
                CustomerAllInfo customerAllInfo;
                this.thirdManagerService.updateAuthority(pagesId, authId);
                if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u4fee\u6539\u804c\u4f4d\u6743\u9650", "\u4fee\u6539\u804c\u4f4d\uff1a" + authority.getDesignation() + "\u7684\u6743\u9650-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u804c\u4f4d\u6743\u9650");
                }
                return "";
            }
            return "-1";
        }
        return "-1";
    }
}

