/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.goods.bean.GoodsGroup;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsGroupReleProductService;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.vo.GoodsGroupVo;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.MyLogger;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdGoodsGroupController {
    private static final MyLogger LOGGER = new MyLogger(ThirdGoodsGroupController.class);
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="ThirdOtherService")
    private ThirdOtherService thirdOtherService;
    @Resource(name="GoodsGroupService")
    private GoodsGroupService goodsGroupService;
    @Resource(name="GoodsGroupReleProductService")
    private GoodsGroupReleProductService goodsGroupReleProductService;

    @RequestMapping(value={"/thirdGoodsGroupManager"})
    public ModelAndView thirdGoodsGroupManager(PageBean pb, GoodsGroup group, String n, String l, HttpServletRequest request) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        ModelAndView mav = new ModelAndView();
        try {
            PageBean queryThirdGoodsGroupByPageBeanAndSearchBean = this.goodsGroupService.queryThirdGoodsGroupByPageBeanAndSearchBean(pb, group);
            mav.addObject("pb", (Object)queryThirdGoodsGroupByPageBeanAndSearchBean);
            mav.setViewName("goods/thirdgoodsgroup");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u67e5\u8be2\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/addThirdGoodsGroup"})
    public ModelAndView addThirdGoodsGroup(HttpServletRequest request, @Valid GoodsGroup goodsGroup, BindingResult resut) {
        ModelAndView mav = new ModelAndView();
        String name = ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername();
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        String storeName = (String)request.getSession().getAttribute("storeName");
        try {
            goodsGroup.setThirdId(thirdId);
            goodsGroup.setThirdName(storeName);
            goodsGroup.setIsThird("1");
            goodsGroup.setGroupDelflag("0");
            goodsGroup.setGroupCreateTime(new Date());
            goodsGroup.setGroupCreateName(name);
            this.goodsGroupService.saveGoodsGroup(goodsGroup);
            mav.setView((View)new RedirectView("thirdGoodsGroupManager.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u6dfb\u52a0\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/batchDelThirdGoodsGroup"})
    public ModelAndView batchDelThirdGoodsGroup(Long[] groupIds, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String name = ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername();
        try {
            Long thirdId = (Long)request.getSession().getAttribute("thirdId");
            this.goodsGroupService.batchDelGroup(thirdId, groupIds, name);
            this.goodsGroupService.deleteShoppingCartByFitIds(groupIds);
            mav.setView((View)new RedirectView("thirdGoodsGroupManager.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/delThirdGoodsGroup"})
    public ModelAndView delThirdGoodsGroup(Long groupId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String name = (String)request.getSession().getAttribute("name");
        try {
            this.goodsGroupService.delGoodsGroup(groupId, name);
            Long[] ids = new Long[]{groupId};
            this.goodsGroupService.deleteShoppingCartByFitIds(ids);
            mav.setView((View)new RedirectView("thirdGoodsGroupManager.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u5355\u4e2a\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryThirdGoodsGroupByPrimaryKey"})
    public ModelAndView queryGroupVoByPrimaryKey(Long groupId, String n, String l, HttpServletRequest request) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        try {
            GoodsGroupVo groupVo = this.goodsGroupService.queryVoByPrimaryKey(groupId);
            List brandList = this.thirdOtherService.queryGrandBrandByThirdId(thirdId);
            String basicAddress = this.basicSetService.findBasicSet().getBsetAddress();
            basicAddress = BasicSetUtil.getAddress((String)basicAddress);
            mav.addObject("groupVo", (Object)groupVo);
            mav.addObject("brandList", (Object)brandList);
            mav.addObject("basicAddress", (Object)basicAddress);
            mav.setViewName("goods/thirdgoodsgroupproduct");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u5546\u54c1\u7ec4\u5408\u4fee\u6539\u8df3\u8f6c\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/saveThirdGroupReleProduct"})
    public ModelAndView saveThirdGroupReleProduct(Long groupId, Long[] productId, Long[] num, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            this.goodsGroupReleProductService.addGroupReleProductNew(groupId, productId, num);
            mav.setView((View)new RedirectView("queryThirdGoodsGroupByPrimaryKey.htm?groupId=" + groupId));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u6839\u636e\u7ec4\u5408ID\u548c\u8d27\u54c1ID\u6570\u7ec4\u65b0\u5efa\u5173\u8054\u5173\u7cfb\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/delThirdGroupReleProduct"})
    public ModelAndView delThirdGroupReleProduct(Long groupId, Long productId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            this.goodsGroupReleProductService.delGroupReleProductByGroupIdAndProductId(groupId, productId);
            mav.setView((View)new RedirectView("queryThirdGoodsGroupByPrimaryKey.htm?groupId=" + groupId));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u6839\u636e\u7ec4\u5408ID\u548cproductId\u5220\u9664\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/updateThirdGroup"})
    public ModelAndView updateThirdGroup(@Valid GoodsGroup group, BindingResult resut, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String name = (String)request.getSession().getAttribute("name");
        try {
            this.goodsGroupService.updateGoodsGroup(group, name);
            mav.setView((View)new RedirectView("thirdGoodsGroupManager.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u4fdd\u5b58\u5546\u54c1\u7ec4\u5408\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }
}

