/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.controller;

import com.qianjiang.comment.service.EmailUtilsSiteService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerFollow;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.service.CustomerFollowServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.bean.GoodsImage;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GetOnOffService;
import com.qianjiang.goods.service.GoodsAuditService;
import com.qianjiang.goods.service.GoodsImageService;
import com.qianjiang.goods.service.GoodsOpenSpecService;
import com.qianjiang.goods.service.GoodsOpenSpecValueService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSuppService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadUtil;
import com.qianjiang.util.UtilDate;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdProductController {
    public static final MyLogger LOGGER = new MyLogger(ThirdProductController.class);
    private static final String SPECID = "specId";
    private static final String SPECDETAILID = "specDetailId";
    private static final String THIRDID = "thirdId";
    private static final String SUPPORTIDS = "support";
    private static final String SPECREMARK = "specRemark";
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="GoodsSpecService")
    private GoodsSpecService goodsSpecService;
    @Resource(name="GoodsImageService")
    private GoodsImageService goodsImageService;
    @Resource(name="GoodsOpenSpecService")
    private GoodsOpenSpecService goodsOpenSpecService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="goodsAuditService")
    private GoodsAuditService goodsAuditService;
    @Resource(name="GetOnOffService")
    private GetOnOffService getOnOffService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="customerFollowServiceMapper")
    private CustomerFollowServiceMapper customerFollowServiceMapper;
    @Resource(name="GoodsProductSuppService")
    private GoodsProductSuppService goodsProductSuppService;
    @Resource(name="emailSiteUtils")
    private EmailUtilsSiteService emailUtilsSiteService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;
    @Resource(name="GoodsOpenSpecValueService")
    private GoodsOpenSpecValueService goodsOpenSpecValueService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/thirdProductManager"})
    public ModelAndView thirdProductManager(Long goodsId, PageBean pb, String flag, SelectBean selectBean, Long goodsAddedSta) throws UnsupportedEncodingException {
        selectBean.setSearchText(new String(selectBean.getSearchText().getBytes("ISO-8859-1"), "utf-8"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("pb", this.goodsProductService.queryByGoodsId(goodsId, pb, selectBean));
            map.put("specs", this.goodsOpenSpecService.queryOpenListByGoodsIdInBoss(goodsId));
            map.put("goodsId", goodsId);
            map.put("flag", flag);
            map.put("goodsAddedSta", goodsAddedSta);
            map.put("selectBean", selectBean);
            map.put("isThirdAuditUsed", this.getOnOffService.getOnOffFlag());
            map.put("allProductSuppList", this.serviceSupportMapperService.selectAll());
            ModelAndView modelAndView = new ModelAndView("goods/thirdProductManager", "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/saveThirdProduct"})
    public ModelAndView saveThirdProduct(GoodsProduct product, HttpServletRequest request) {
        String[] specIds = request.getParameterValues(SPECID);
        String[] specDetailId = request.getParameterValues(SPECDETAILID);
        try {
            product.setIsThird("1");
            product.setThirdId((Long)request.getSession().getAttribute(THIRDID));
            product.setThirdName((String)request.getSession().getAttribute("storeName"));
            this.goodsProductService.saveProduct(product, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), specIds, specDetailId, null);
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + product.getGoodsId()));
            return modelAndView;
        }
        finally {
            specIds = null;
            specDetailId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateThirdProduct"})
    public ModelAndView updateThirdProduct(GoodsProduct goodsProduct, HttpServletRequest request, String oldPrice, Long goodsAddedSta) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Goods goodthird = this.goodsService.queryGoodsByGoodsId(goodsProduct.getGoodsId());
        Long goodsBelo = null;
        Long goodsInfoThirdId = null;
        if (goodthird != null) {
            goodsBelo = goodthird.getGoodsBelo();
        }
        GoodsProduct product = this.goodsProductService.queryProductByGoodsId(goodsProduct.getGoodsInfoId());
        if (goodsProduct != null) {
            goodsInfoThirdId = product.getThirdId();
        }
        if (thirdId.equals(goodsBelo) && thirdId.equals(goodsInfoThirdId)) {
            String[] specIds = request.getParameterValues(SPECID);
            String[] specDetailId = request.getParameterValues(SPECDETAILID);
            String[] supportIds = request.getParameterValues(SUPPORTIDS);
            String[] specRemark = request.getParameterValues(SPECREMARK);
            String isThirdAuditUsed = this.getOnOffService.getOnOffFlag();
            Boolean flag = this.goodsProductService.compare(product, goodsProduct, supportIds, specDetailId);
            if (flag.booleanValue()) {
                goodsProduct.setAuditStatus("3");
            } else if (Integer.parseInt(isThirdAuditUsed) == 1) {
                if ("0".equals(goodsProduct.getGoodsInfoAdded())) {
                    goodsProduct.setAuditStatus("0");
                } else {
                    goodsProduct.setGoodsInfoAdded("0");
                    goodsProduct.setAuditStatus("1");
                }
            } else {
                goodsProduct.setAuditStatus("3");
            }
            this.goodsProductSuppService.delAll(goodsProduct.getGoodsInfoId());
            if (supportIds != null && supportIds.length > 0) {
                this.goodsProductSuppService.batchInsert(supportIds, goodsProduct.getGoodsInfoId().intValue());
            }
            try {
                Customer cust;
                this.goodsProductService.updateProduct(goodsProduct, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), specIds, specDetailId, specRemark);
                this.goodsOpenSpecValueService.queryOpenListByGoodsAndSpecValueId(goodsProduct.getGoodsId(), specDetailId);
                BigDecimal oldprices = new BigDecimal(oldPrice);
                Long goodsInfoId = goodsProduct.getGoodsInfoId();
                if (oldprices.compareTo(goodsProduct.getGoodsInfoPreferPrice()) == 1) {
                    List customerIds = new ArrayList();
                    customerIds = this.customerFollowServiceMapper.selectSendId(goodsInfoId);
                    for (int a = 0; a < customerIds.size(); ++a) {
                        CustomerFollow customerIdd = (CustomerFollow)customerIds.get(a);
                        Long customerId = customerIdd.getCustomerId();
                        CustomerInfo infoEmails = this.customerServiceMapper.email(customerId);
                        CustomerInfo mobiles = this.customerServiceMapper.mobile(customerId);
                        String infoEmail = infoEmails.getInfoEmail();
                        String mobile = mobiles.getInfoMobile();
                        if (infoEmail != null) {
                            // empty if block
                        }
                        if (mobile == null) continue;
                    }
                }
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u8d27\u54c1", "\u4fee\u6539\u8d27\u54c1\uff0c\u8d27\u54c1\u7f16\u53f7\u3010" + goodsProduct.getGoodsInfoItemNo() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u8d27\u54c1");
                }
                this.searchAsyncService.updateOneGoodsIndexToEs(goodsProduct.getGoodsId());
                ModelAndView modelAndView = new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + goodsProduct.getGoodsId() + "&goodsAddedSta=" + goodsAddedSta));
                return modelAndView;
            }
            finally {
                specIds = null;
                specDetailId = null;
            }
        }
        return null;
    }

    @RequestMapping(value={"/saveThirdProductImage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsImage saveThirdProductImage(Long productId, HttpServletRequest request, MultipartHttpServletRequest request2) {
        List fileList = request2.getFiles("filedata");
        ArrayList<Map> picList = null;
        if (null != fileList && !fileList.isEmpty()) {
            picList = new ArrayList<Map>();
            for (int i = 0; i < fileList.size(); ++i) {
                if (((MultipartFile)fileList.get(i)).isEmpty()) continue;
                Map imagePath = UploadUtil.uploadFile((MultipartFile)((MultipartFile)fileList.get(i)));
                picList.add(imagePath);
            }
        }
        return this.goodsImageService.uploadImage(productId, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), picList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateThirdProductImage"})
    public ModelAndView updateThirdProductImage(Long goodsImgId, Long productId, Long goodsId, HttpServletRequest request, HttpServletResponse response, MultipartHttpServletRequest request2, Long goodsAddedSta) {
        GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(productId);
        String defaultImage = request.getParameter("defaultImage");
        this.goodsImageService.setDefaultImage(productId, goodsImgId);
        String[] delIamges = request.getParameterValues("delImages");
        try {
            Customer cust;
            this.goodsImageService.batchDelImage(delIamges, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
            this.goodsImageService.setDefaultImage(productId, defaultImage, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
            List fileList = request2.getFiles("filedata");
            ArrayList<Map> picList = null;
            if (null != fileList && !fileList.isEmpty()) {
                picList = new ArrayList<Map>();
                for (int i = 0; i < fileList.size(); ++i) {
                    if (((MultipartFile)fileList.get(i)).isEmpty()) continue;
                    Map imagePath = UploadUtil.uploadFile((MultipartFile)((MultipartFile)fileList.get(i)));
                    picList.add(imagePath);
                }
            }
            this.goodsImageService.uploadImage(productId, (String)request.getSession().getAttribute("name"), picList);
            this.searchAsyncService.updateOneGoodsIndexToEs(goodsId);
            if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u8d27\u54c1\u56fe\u7247", "\u4fee\u6539\u8d27\u54c1\u56fe\u7247\uff0c\u8d27\u54c1\u540d\u79f0\u3010" + goodsProductVo.getGoodsInfoName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u4fee\u6539\u8d27\u54c1\u56fe\u7247");
            }
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + goodsId + "&goodsAddedSta=" + goodsAddedSta));
            return modelAndView;
        }
        finally {
            defaultImage = null;
            delIamges = null;
        }
    }

    @RequestMapping(value={"/delThirdProduct"})
    public ModelAndView delThirdProduct(Long goodsId, Long productId, HttpServletRequest request, Long goodsAddedSta) {
        Customer cust;
        GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(productId);
        this.goodsProductService.delThirdProductByProductId(productId, (Long)request.getSession().getAttribute(THIRDID), ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        this.searchAsyncService.deleteGoodsIndexToEs(productId);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u5220\u9664\u8d27\u54c1", "\u5220\u9664\u8d27\u54c1\uff0c\u8d27\u54c1\u540d\u79f0\u3010" + goodsProductVo.getGoodsInfoName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u5220\u9664\u8d27\u54c1");
        }
        return new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + goodsId + "&goodsAddedSta=" + goodsAddedSta));
    }

    @RequestMapping(value={"/batchDelThirdProduct"})
    public ModelAndView batchDelThirdProduct(Long goodsId, Long[] productIds, HttpServletRequest request) {
        this.goodsProductService.batchDelProduct(productIds, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        for (Long productId : productIds) {
            this.searchAsyncService.deleteGoodsIndexToEs(productId);
        }
        return new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + goodsId));
    }

    @RequestMapping(value={"/batchUploadThirdProduct"})
    public ModelAndView batchUploadThirdProduct(Long goodsId, Long[] productId, HttpServletRequest request, String auditStatus, Long goodsAddedSta) {
        String auditStatusNew = auditStatus;
        String isThirdAuditUsed = this.getOnOffService.getOnOffFlag();
        if (Integer.parseInt(isThirdAuditUsed) == 1) {
            auditStatusNew = isThirdAuditUsed;
            this.goodsProductService.batchAuditUploadProduct(((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), productId, Integer.valueOf(1), auditStatusNew);
        } else {
            this.goodsProductService.batchUploadProduct(((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), productId, Integer.valueOf(1));
        }
        this.searchAsyncService.updateOneGoodsIndexToEs(goodsId);
        return new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + goodsId + "&goodsAddedSta=" + goodsAddedSta));
    }

    @RequestMapping(value={"/batchDownThirdProduct"})
    public ModelAndView batchDownThirdProduct(Long goodsId, Long[] productId, HttpServletRequest request, Long goodsAddedSta) {
        this.goodsProductService.batchUploadProduct(((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), productId, Integer.valueOf(0));
        this.searchAsyncService.deleteGoodsIndexToEs(goodsId);
        return new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + goodsId + "&goodsAddedSta=" + goodsAddedSta));
    }

    @RequestMapping(value={"/queryThirdProductVoByProductId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryThirdProductVoByProductId(Long thirdProductId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("productSuppList", this.goodsProductSuppService.queryAllSuppByProductId(thirdProductId));
        map.put("product", this.goodsProductService.queryByPrimaryId(thirdProductId));
        return map;
    }

    @RequestMapping(value={"/thirdCreateProduct"})
    public ModelAndView thirdCreateProduct(Long goodsId, HttpServletRequest request) {
        this.goodsService.saveProductWhenClickBatchCreate(goodsId, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        this.searchAsyncService.insertOneGoodsIndexToEs(goodsId);
        return new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + goodsId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/tNewUploadProduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView newUploadProduct(@Valid GoodsProduct product, HttpServletRequest request, String addedTime, Long goodsAddedSta) {
        String[] specIds = request.getParameterValues(SPECID);
        String[] specDetailId = request.getParameterValues(SPECDETAILID);
        String[] specRemark = request.getParameterValues(SPECREMARK);
        String[] images = request.getParameterValues("image");
        String[] supportId = request.getParameterValues(SUPPORTIDS);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        try {
            Customer cust;
            String isThirdAuditUsed;
            map.put(SPECREMARK, specRemark);
            product.setIsThird("1");
            product.setThirdId((Long)request.getSession().getAttribute(THIRDID));
            product.setThirdName((String)request.getSession().getAttribute("storeName"));
            if ("4".equals(product.getGoodsInfoAdded())) {
                product.setGoodsInfoAddedTime(UtilDate.stringToDate((String)addedTime));
            }
            if (Integer.parseInt(isThirdAuditUsed = this.getOnOffService.getOnOffFlag()) == 1) {
                product.setGoodsInfoAdded("0");
                product.setAuditStatus("1");
            } else {
                product.setGoodsInfoAdded("1");
                product.setAuditStatus("3");
            }
            this.goodsOpenSpecValueService.queryOpenListByGoodsAndSpecValueId(product.getGoodsId(), specDetailId);
            int newId = this.goodsProductService.saveProduct(product, (String)request.getSession().getAttribute("name"), specIds, specDetailId, map);
            this.goodsImageService.batchSaveImage(images, newId, (String)request.getSession().getAttribute("name"));
            this.goodsProductSuppService.batchInsert(supportId, newId);
            this.searchAsyncService.insertOneGoodsIndexToEs(product.getGoodsId());
            if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u8d27\u54c1", "\u6dfb\u52a0\u8d27\u54c1\uff0c\u8d27\u54c1\u540d\u79f0\u3010" + product.getGoodsInfoName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u6dfb\u52a0\u8d27\u54c1");
            }
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView("thirdProductManager.html?goodsId=" + product.getGoodsId() + "&goodsAddedSta=" + goodsAddedSta));
            return modelAndView;
        }
        finally {
            supportId = null;
            images = null;
            specIds = null;
            specDetailId = null;
            map = null;
        }
    }

    @RequestMapping(value={"/thirdproducts"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean goodsManger(PageBean pb, GoodsSearchBean searchBean, HttpServletRequest request, String goodsInfoAdded, BigDecimal offValue) {
        PageBean productList = null;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            if (searchBean.getGoodsInfoName() != null && !"".equals(searchBean.getGoodsInfoName())) {
                String goodsInfoName = URLDecoder.decode(searchBean.getGoodsInfoName(), "UTF-8");
                searchBean.setGoodsInfoName(goodsInfoName);
            }
            productList = this.goodsProductService.newQueryProductList(pb, thirdId, searchBean, offValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u67e5\u8be2\u53c2\u52a0\u4fc3\u9500\u7684\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return productList;
    }
}

