/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.grandbrand.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.third.grandbrand.service.GrandBrandService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdGrandBrandController {
    private static final Logger LOGGER = Logger.getLogger(ThirdGrandBrandController.class);
    private static final String THIRDID = "thirdId";
    private static final String TABSTATUS = "?tabStatus=";
    private GrandBrandService service;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;

    @RequestMapping(value={"/checkGoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkGoods(Long brandId, HttpServletRequest request) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        return this.service.checkGoodCount(brandId, thirdId);
    }

    @RequestMapping(value={"/queryThirdGrandBrandLists"})
    public ModelAndView queryThirdGrandBrandLists(GoodsBrand goodsBrand, PageBean pb, HttpServletRequest request, String n, String l, String tabStatus) {
        String nNew = n;
        String lNew = l;
        String tabStatusNew = tabStatus;
        if (nNew == null || lNew == null || "".equals(nNew) || "".equals(lNew)) {
            nNew = "2";
            lNew = "63";
        }
        MenuOperationUtil.fillSessionMenuIndex(request, nNew, lNew);
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (tabStatusNew == null || "1".equals(tabStatusNew) || "".equals(tabStatusNew)) {
            tabStatusNew = null;
            mav.setViewName("/grandbrand/thirdgrandbrandLists");
            pb.setUrl("queryThirdGrandBrandLists.html?n=" + nNew + "&l=" + lNew);
        } else {
            mav.setViewName("/grandbrand/thirdapplyBrandList");
            pb.setUrl("queryThirdGrandBrandLists.html?n=" + nNew + "&l=" + lNew + "&tabStatus=2");
        }
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        map.put("pb", this.service.queryAllGoodsGrandBrand(pb, goodsBrand, tabStatusNew, thirdId));
        map.put("goodsBrand", goodsBrand);
        map.put("tab_status", tabStatusNew);
        return mav.addObject("map", map);
    }

    @RequestMapping(value={"/queryForGrandBrandLists"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryForGrandBrandLists(HttpServletRequest request, GoodsBrand goodsBrand, PageBean pb) {
        pb.setPageSize(16);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        return this.service.queryForGoodsGrandBrand(pb, goodsBrand, thirdId, "2");
    }

    @RequestMapping(value={"/changeThirdGrandBrand"})
    public ModelAndView changeThirdGrandBrand(String brandIds, HttpServletRequest request, String tabStatus) {
        CustomerAllInfo customerAllInfo;
        String[] brandId = brandIds.split(",");
        this.service.forTheGoodsBrand(brandId, (Long)request.getSession().getAttribute(THIRDID));
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5546\u5bb6\u7533\u8bf7\u54c1\u724c", "\u5546\u5bb6\u7533\u8bf7\u54c1\u724c-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u5546\u5bb6\u7533\u8bf7\u54c1\u724c");
        }
        return new ModelAndView((View)new RedirectView("queryThirdGrandBrandLists.htm?tabStatus=" + tabStatus), "tab_status", (Object)tabStatus);
    }

    @RequestMapping(value={"/updateGrandBrand"})
    public ModelAndView updateGrandBrand(GoodsBrand goodsBrand, HttpServletRequest request, String tabStatus) {
        CustomerAllInfo customerAllInfo;
        goodsBrand.setThirdId((Long)request.getSession().getAttribute(THIRDID));
        this.service.updateGrandBrand(goodsBrand);
        goodsBrand = this.service.queryBrandById(goodsBrand.getBrandId());
        this.service.updateApplyBrandByName(goodsBrand.getBrandName());
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u54c1\u724c\u5217\u8868\u5220\u9664\u5546\u5bb6\u54c1\u724c", "\u54c1\u724c\u5217\u8868\u4e2d\u5220\u9664\u5546\u5bb6\u54c1\u724c\uff0c\u54c1\u724c\u540d\u79f0\uff1a" + goodsBrand.getBrandName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u54c1\u724c\u5217\u8868\u5220\u9664\u5546\u5bb6\u54c1\u724c");
        }
        return new ModelAndView((View)new RedirectView("queryThirdGrandBrandLists.htm?tabStatus=" + tabStatus), "tab_status", (Object)tabStatus);
    }

    @RequestMapping(value={"/updateGrandBrands"})
    public ModelAndView updateGrandBrands(Long[] brandIds, HttpServletRequest request, String tabStatus) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        this.service.updateGrandBrands(brandIds, thirdId);
        return new ModelAndView((View)new RedirectView("queryThirdGrandBrandLists.htm?tabStatus=" + tabStatus), "tab_status", (Object)tabStatus);
    }

    public GrandBrandService getService() {
        return this.service;
    }

    @Resource(name="GrandBrandService")
    public void setService(GrandBrandService service) {
        this.service = service;
    }
}

