/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.login.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.license.service.LicenseImportService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.service.SysBasicService;
import com.qianjiang.system.vo.HelpCenterVo;
import com.qianjiang.third.auth.bean.ThirdPage;
import com.qianjiang.third.auth.service.ThirdAuthorityPageService;
import com.qianjiang.third.login.service.LoginService;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.MyLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class LoginController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String HEPLCATE_NAME = "\u5e2e\u52a9\u4e2d\u5fc3";
    private static final String PATCHCA = "PATCHCA";
    private static final String CUSTOMERID = "customerId";
    private static final String CUSTOMER = "customer";
    private static final String CUSTOMERALLINFO = "customerallInfo";
    private static final String SITEURL = "siteUrl";
    private static final String THIRDID = "thirdId";
    private static final String STATUS = "status";
    private static final String LOGIN = "login";
    private static final String PEX_HTML = ".html";
    private static final String MALL_USERNAME = "_mall_username";
    private static final String CREATEURL = "createUrl";
    private static final String BASICSET = "basicSet";
    private static final String USERMOBILE = "userMobile";
    public static final MyLogger LOGGER = new MyLogger(LoginController.class);
    @Resource(name="auditService")
    private AuditService auditService;
    private LoginService loginService;
    private ThirdAuthorityPageService thirdAuthorityPageService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;
    @Resource(name="SysBasicService")
    private SysBasicService sysBasicService;
    private SellerService sellerService;
    @Resource(name="thirdAuthorityPageService")
    private ThirdAuthorityPageService thirdManagerService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="sellerService")
    public SellerService sotreInfoMapper;
    @Resource(name="licenseImportService")
    public LicenseImportService licenseImportService;

    @RequestMapping(value={"third/waitaudit"})
    public ModelAndView waitAudit(HttpServletRequest request) {
        HashMap<String, StoreInfo> resultMap = new HashMap<String, StoreInfo>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(customerId);
        List helpCate = this.helpCenterService.selectCateByHelpname(HEPLCATE_NAME);
        resultMap.put("storeinfo", this.sellerService.selectRefuseInfo((Long)request.getSession().getAttribute(CUSTOMERID)));
        request.getSession().setAttribute(CUSTOMER, (Object)customer);
        if (null != helpCate && !helpCate.isEmpty()) {
            HelpCenterVo helpCatess = (HelpCenterVo)helpCate.get(0);
            request.getSession().setAttribute("help", (Object)this.helpCenterService.findByCateId(helpCatess.getHelpcateId()));
        }
        request.getSession().setAttribute(SITEURL, (Object)this.basicSetService.findBasicSet());
        return new ModelAndView("/openstore/waitaudit").addAllObjects(resultMap);
    }

    @RequestMapping(value={"third/waitauditcheck"})
    public ModelAndView waitauditcheck(HttpServletRequest request) {
        HashMap<String, StoreInfo> resultMap = new HashMap<String, StoreInfo>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(customerId);
        List helpCate = this.helpCenterService.selectCateByHelpname(HEPLCATE_NAME);
        resultMap.put("storeinfo", this.sellerService.selectRefuseInfo((Long)request.getSession().getAttribute(CUSTOMERID)));
        request.getSession().setAttribute(CUSTOMER, (Object)customer);
        if (null != helpCate && !helpCate.isEmpty()) {
            HelpCenterVo helpCatess = (HelpCenterVo)helpCate.get(0);
            request.getSession().setAttribute("help", (Object)this.helpCenterService.findByCateId(helpCatess.getHelpcateId()));
        }
        request.getSession().setAttribute(SITEURL, (Object)this.basicSetService.findBasicSet());
        return new ModelAndView("/openstore/waitauditcheck").addAllObjects(resultMap);
    }

    @RequestMapping(value={"/index/goenterpage"})
    public ModelAndView goenterpage(HttpServletRequest request) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        StoreInfo storeInfo = null;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(customerId);
        if (customer.getThirdId() != null) {
            storeInfo = "2".equals(customer.getIsSeller()) ? this.sotreInfoMapper.selectByEmployeeId(customer.getCustomerId()) : this.sotreInfoMapper.selectByCustomerId(customer.getCustomerId());
            if (storeInfo != null) {
                if ("1".equals(storeInfo.getCheckStatus()) && "1".equals(storeInfo.getIsSubmit())) {
                    request.getSession().setAttribute(THIRDID, (Object)customer.getThirdId());
                    request.getSession().setAttribute("storeName", (Object)storeInfo.getStoreName());
                    request.getSession().setAttribute("isStoreIndex", (Object)storeInfo.getIsStoreIndex());
                    objectMap.put(STATUS, 1);
                    Long days = (storeInfo.getExpiryTime().getTime() - new Date().getTime()) / 86400000L;
                    objectMap.put("days", days);
                } else {
                    objectMap.put(STATUS, 6);
                }
            } else if ("0".equals(customer.getIsSeller()) || "3".equals(customer.getIsSeller())) {
                objectMap.put(STATUS, 5);
            }
        } else {
            objectMap.put(STATUS, 0);
        }
        List helpCate = this.helpCenterService.selectCateByHelpname(HEPLCATE_NAME);
        objectMap.put("storeInfo", storeInfo);
        objectMap.put(CUSTOMER, customer);
        request.getSession().setAttribute(CUSTOMER, (Object)customer);
        if (null != helpCate && !helpCate.isEmpty()) {
            HelpCenterVo helpCatess = (HelpCenterVo)helpCate.get(0);
            request.getSession().setAttribute("help", (Object)this.helpCenterService.findByCateId(helpCatess.getHelpcateId()));
        }
        request.getSession().setAttribute(SITEURL, (Object)this.basicSetService.findBasicSet());
        List thirdPages = this.thirdManagerService.queryMenuByManager(customerId);
        String firstUrl = "";
        boolean str = false;
        if (thirdPages != null && !thirdPages.isEmpty()) {
            for (int j = 0; j < thirdPages.size(); ++j) {
                if (((ThirdPage)thirdPages.get(j)).getMenuVos() == null || ((ThirdPage)thirdPages.get(j)).getMenuVos().isEmpty()) continue;
                int i = 0;
                if (i < ((ThirdPage)thirdPages.get(j)).getMenuVos().size()) {
                    if ("sellerinfo.html".equals(((ThirdPage)thirdPages.get(j)).getMenuVos().get(i).getUrl())) {
                        firstUrl = ((ThirdPage)thirdPages.get(j)).getMenuVos().get(i).getUrl() + "?n=" + ((ThirdPage)thirdPages.get(j)).getId() + "&l=" + ((ThirdPage)thirdPages.get(j)).getMenuVos().get(i).getId();
                        str = true;
                    } else {
                        firstUrl = ((ThirdPage)thirdPages.get(0)).getMenuVos().get(0).getUrl() + "?n=" + ((ThirdPage)thirdPages.get(0)).getId() + "&l=" + ((ThirdPage)thirdPages.get(0)).getMenuVos().get(0).getId();
                    }
                }
                if (str) break;
            }
        }
        return new ModelAndView("/index/goenterpage").addObject("objectMap", objectMap).addObject("firstUrl", (Object)firstUrl);
    }

    @RequestMapping(value={"/jumplogin"})
    public ModelAndView jumpLogin() {
        return new ModelAndView((View)new RedirectView(LOGIN));
    }

    public void init() {
        try {
            super.init();
        }
        catch (ServletException e) {
            LOGGER.error("" + (Object)((Object)e));
        }
    }

    Color getRandColor(int fc, int bc) {
        int fcNew = fc;
        int bcNew = bc;
        Random random = new Random();
        if (fcNew > 255) {
            fcNew = 255;
        }
        if (bcNew > 255) {
            bcNew = 255;
        }
        int r = fcNew + random.nextInt(bcNew - fcNew);
        int g = fcNew + random.nextInt(bcNew - fcNew);
        int b = fcNew + random.nextInt(bcNew - fcNew);
        return new Color(r, g, b);
    }

    @RequestMapping(value={"/writeCaptcha"})
    public void writeCaptcha(HttpServletResponse response) throws ServletException {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        int width = 60;
        int height = 20;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        g.setColor(this.getRandColor(220, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.draw3DRect(0, 0, width - 1, height - 1, true);
        for (int i = 0; i < 155; ++i) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }
        String sRand = "";
        String s = "012345678901234567890123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012345678901234567890123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        for (int i = 0; i < 4; ++i) {
            char rand = s.charAt(random.nextInt(s.length()));
            sRand = sRand + rand;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(String.valueOf(rand), 13 * i + 6, 16);
        }
        g.drawOval(0, 12, 60, 11);
        Cookie cookie = new Cookie("sRand", sRand);
        cookie.setMaxAge(10000);
        response.addCookie(cookie);
        g.dispose();
        try {
            ServletOutputStream output = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)output);
        }
        catch (IOException e) {
            LOGGER.error("" + e);
        }
    }

    @RequestMapping(value={"/customer/login"})
    public ModelAndView login(HttpServletRequest request, String url) throws UnsupportedEncodingException {
        String requestURI;
        request.getSession().invalidate();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String urlEmp = url;
        String preUrl = request.getHeader("Referer");
        if (preUrl != null) {
            String strRegex = "^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([0-9a-z][0-9a-z-]{0,61}))(:[0-9]{1,5})?" + request.getContextPath() + "/";
            urlEmp = preUrl.replaceFirst(strRegex, "");
        } else {
            preUrl = (String)request.getSession().getAttribute("preferUrl");
            urlEmp = preUrl != null ? preUrl : "index.html";
        }
        if (urlEmp.indexOf("register") != -1 || urlEmp.indexOf("success") != -1 || urlEmp.indexOf(LOGIN) != -1 || urlEmp.indexOf("storetip") != -1) {
            urlEmp = "index.html";
        }
        if (urlEmp.indexOf(PEX_HTML) == -1) {
            urlEmp = urlEmp + PEX_HTML;
        }
        if ((requestURI = request.getRequestURI()).indexOf(PEX_HTML) == -1 && requestURI.indexOf("/newthird") != -1) {
            urlEmp = "index.html";
        }
        if (requestURI.indexOf(PEX_HTML) == -1 && requestURI.indexOf("/mall_supplier") != -1) {
            urlEmp = "index.html";
        }
        resultMap.put("errCount", this.loginService.getErrCount(request));
        resultMap.put(BASICSET, this.basicSetService.findBasicSet());
        MenuOperationUtil.fillSessionHttpUrl(request, urlEmp);
        this.setResultMap(request, resultMap, urlEmp);
        request.getSession().setAttribute("sysBasic", (Object)this.sysBasicService.getSysBasic());
        return new ModelAndView("/login/newlogin").addAllObjects(resultMap);
    }

    @RequestMapping(value={"/customer/registersucceed"})
    public ModelAndView registersucceed(HttpServletRequest request, String url) throws UnsupportedEncodingException {
        return new ModelAndView((View)new RedirectView("jumplogin.htm"));
    }

    @RequestMapping(value={"/customer/logout"})
    public ModelAndView loginOut(HttpServletRequest request, String url) throws UnsupportedEncodingException {
        String urlNew = url;
        if (urlNew == null) {
            urlNew = "index.html";
        }
        request.getSession().removeAttribute("cust");
        request.getSession().removeAttribute(CUSTOMERID);
        request.getSession().removeAttribute("bsetDomain");
        return new ModelAndView((View)new RedirectView(LOGIN));
    }

    @RequestMapping(value={"/checklogin"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object checkLogin(HttpServletRequest request, HttpServletResponse response, String username, String password, String type) throws UnsupportedEncodingException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int status = 0;
        if (null != username && null != password) {
            int count;
            String flag = this.licenseImportService.isQualified("third");
            if (!"1".equals(flag)) {
                resultMap.put(STATUS, flag);
                return resultMap;
            }
            Customer customer = this.customerServiceMapper.getCustomerByUsernameType(username);
            if (customer == null) {
                resultMap.put(STATUS, 2);
                return resultMap;
            }
            StoreInfo storeinfo = this.sotreInfoMapper.selectByEmployeeId(customer.getCustomerId());
            if ("1".equals(customer.getIsSeller()) && storeinfo != null && "1".equals(storeinfo.getIsSubmit()) && (count = this.auditService.selectStoreTimeByThirdId(customer.getThirdId())) == 0) {
                resultMap.put(STATUS, 66);
                return resultMap;
            }
            if ("2".equals(customer.getIsSeller())) {
                if ("1".equals(customer.getIsFlag())) {
                    resultMap.put(STATUS, 7);
                    return resultMap;
                }
                int result = this.loginService.checkThirdAuthority(username);
                if (result == 0) {
                    resultMap.put(STATUS, 11);
                    return resultMap;
                }
            }
        }
        if (!"".equals(password)) {
            status = this.loginService.checkCustomerExists(request, username, password);
        }
        if (status == 1) {
            if ("0".equals(type)) {
                Cookie cookie = new Cookie(MALL_USERNAME, URLEncoder.encode(username, "utf-8"));
                cookie.setMaxAge(604800);
                response.addCookie(cookie);
            } else if ("1".equals(type)) {
                Cookie nameCookie = new Cookie(MALL_USERNAME, URLEncoder.encode(username, "utf-8"));
                nameCookie.setMaxAge(604800);
                response.addCookie(nameCookie);
                Cookie pwdCookie = new Cookie("_mall_pwd", URLEncoder.encode(password, "utf-8"));
                pwdCookie.setMaxAge(604800);
                response.addCookie(pwdCookie);
            }
            resultMap.put("url", (String)request.getSession().getAttribute("url"));
            return resultMap;
        }
        if (status == 3) {
            resultMap.put(STATUS, status);
            resultMap.put(CREATEURL, "storetip.html");
            return resultMap;
        }
        if (status == 4) {
            resultMap.put(STATUS, status);
            resultMap.put(CREATEURL, "waitaudit.html");
            return resultMap;
        }
        if (status == 6) {
            resultMap.put(STATUS, status);
            return resultMap;
        }
        if (status == 10) {
            resultMap.put(CREATEURL, "waitauditcheck.html");
            resultMap.put(STATUS, status);
            return resultMap;
        }
        if (status == 7) {
            resultMap.put(STATUS, status);
            return resultMap;
        }
        resultMap.put("errCount", this.loginService.getErrCount(request));
        resultMap.put(STATUS, status);
        return resultMap;
    }

    @RequestMapping(value={"/isloginthird"})
    public ModelAndView getLogin(HttpServletRequest request, HttpServletResponse response, Long customerId, String loginKey) {
        StoreInfo storeInfo = null;
        CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(customerId);
        if (loginKey.equals(customer.getLoginKey())) {
            customer.setCustomerPassword(null);
            customer.setLoginTime(new Date());
            customer.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
            UUID uuid = UUID.randomUUID();
            customer.setLoginKey(uuid.toString());
            this.loginService.updateCustomerLoginTime((Customer)customer);
            request.getSession().setAttribute(CUSTOMERID, (Object)customer.getCustomerId());
            request.getSession().setAttribute("cust", (Object)customer);
            request.getSession().setAttribute("name", (Object)customer.getCustomerUsername());
            request.getSession().setAttribute("bsetDomain", (Object)this.basicSetService.findBasicSet().getBsetDomain());
            if (customer.getThirdId() != null) {
                storeInfo = this.sotreInfoMapper.selectByCustomerId(customer.getCustomerId());
                if (storeInfo != null) {
                    if ("0".equals(storeInfo.getCheckStatus()) && ("1".equals(storeInfo.getIsSubmit()) || storeInfo.getRefuseContent() != null && storeInfo.getRefuseContent().length() != 0)) {
                        return new ModelAndView("/openstore/waitaudit");
                    }
                    if ("1".equals(storeInfo.getCheckStatus()) && "1".equals(storeInfo.getIsSubmit())) {
                        request.getSession().setAttribute(THIRDID, (Object)customer.getThirdId());
                        request.getSession().setAttribute("storeName", (Object)storeInfo.getStoreName());
                        request.getSession().setAttribute("isStoreIndex", (Object)storeInfo.getIsStoreIndex());
                        return new ModelAndView((View)new RedirectView("index.html?n=1&l=15"));
                    }
                    if ("1".equals(storeInfo.getCheckStatus())) {
                        return new ModelAndView("/openstore/waitaudit");
                    }
                } else if ("0".equals(customer.getIsSeller())) {
                    return new ModelAndView("/seller/storetip");
                }
            }
            if ("0".equals(customer.getIsSeller())) {
                return new ModelAndView("/seller/storetip");
            }
            request.getSession().setAttribute(THIRDID, (Object)customer.getThirdId());
            return new ModelAndView((View)new RedirectView("index.html?n=1&l=15"));
        }
        return new ModelAndView((View)new RedirectView("customer/login.htm"));
    }

    public void setResultMap(HttpServletRequest request, Map<String, Object> resultMap, String url) throws UnsupportedEncodingException {
        String username = "";
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !MALL_USERNAME.equals(cookie.getName())) continue;
                username = URLDecoder.decode(cookie.getValue(), "utf-8");
                break;
            }
        }
        resultMap.put("username", username);
    }

    @RequestMapping(value={"/findCodeOne"})
    public ModelAndView findCodeOne() {
        return new ModelAndView("login/find_code1").addObject(BASICSET, (Object)this.basicSetService.findBasicSet());
    }

    @RequestMapping(value={"/findCodeTwo"})
    public ModelAndView findCodeTwo(HttpServletRequest request, String varification, String userName) {
        if (!request.getSession().getAttribute(PATCHCA).equals(varification) || StringUtils.isEmpty((CharSequence)userName)) {
            return new ModelAndView((View)new RedirectView("findCodeOne.htm"));
        }
        Customer customer = this.customerServiceMapper.getCustomerByUsername(userName);
        CustomerAllInfo customerInfo = null;
        if (customer != null && (customerInfo = this.customerServiceMapper.queryCustomerInfo(customer.getCustomerId())) != null) {
            request.getSession().setAttribute(USERMOBILE, (Object)customerInfo.getInfoMobile());
            request.getSession().setAttribute(CUSTOMERID, (Object)customer.getCustomerId());
            request.getSession().setAttribute(CUSTOMERALLINFO, (Object)customerInfo);
        }
        return new ModelAndView("login/find_code2").addObject(BASICSET, (Object)this.basicSetService.findBasicSet()).addObject("user", (Object)customerInfo);
    }

    @RequestMapping(value={"/findCodeThree"})
    public ModelAndView findCodeThree(HttpServletRequest request, String mobile, String codetext) {
        if (!request.getSession().getAttribute(USERMOBILE).toString().equals(mobile) || !request.getSession().getAttribute("mcCode").toString().equals(codetext)) {
            return new ModelAndView((View)new RedirectView("findCodeOne.htm"));
        }
        return new ModelAndView("login/find_code3").addObject(BASICSET, (Object)this.basicSetService.findBasicSet()).addObject("mobile", (Object)mobile).addObject("codetext", (Object)codetext);
    }

    @RequestMapping(value={"/findCodeFour"})
    public ModelAndView findCodeFour(HttpServletRequest request, String mobile, String codetext) {
        return new ModelAndView("login/find_code4").addObject(BASICSET, (Object)this.basicSetService.findBasicSet());
    }

    @ResponseBody
    @RequestMapping(value={"/updatePassword"}, produces={"application/json;charset=UTF-8"})
    public int updatePassword(HttpServletRequest request, String mobile, String codetext, String password) {
        if (!request.getSession().getAttribute(USERMOBILE).toString().equals(mobile) || !request.getSession().getAttribute("mcCode").toString().equals(codetext)) {
            return 2;
        }
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        if (customerId != null) {
            return this.customerServiceMapper.updatePwdInfo(customerId, password) ? 1 : 0;
        }
        return 3;
    }

    @RequestMapping(value={"/toSellersPages"})
    public ModelAndView toSellersPages(HttpServletRequest request, ModelMap model) {
        ModelAndView view = new ModelAndView("help/sellers");
        return view;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    @Resource(name="loginServiceThird")
    public void setLoginService(LoginService loginService) {
        this.loginService = loginService;
    }

    public ThirdAuthorityPageService getThirdAuthorityPageService() {
        return this.thirdAuthorityPageService;
    }

    @Resource(name="thirdAuthorityPageService")
    public void setThirdAuthorityPageService(ThirdAuthorityPageService thirdAuthorityPageService) {
        this.thirdAuthorityPageService = thirdAuthorityPageService;
    }

    public SellerService getSellerService() {
        return this.sellerService;
    }

    @Resource(name="sellerService")
    public void setSellerService(SellerService sellerService) {
        this.sellerService = sellerService;
    }
}

