/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.logisticsSingle;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.system.bean.LogisticsSingle;
import com.qianjiang.system.service.LogisticsSingleService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.seller.bean.Express;
import com.qianjiang.third.seller.service.ExpressInfoService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="thirdLogisticsSingleController")
public class LogisticsSingleController {
    private static final Logger LOGGER = Logger.getLogger(LogisticsSingleController.class);
    @Resource(name="LogisticsSingleService")
    private LogisticsSingleService logisticsSingleService;
    @Resource(name="expressInfoService")
    private ExpressInfoService expressInfoService;
    private static final String THIRDID = "thirdId";

    @RequestMapping(value={"/logisticssingleThirdList"})
    public ModelAndView getLogisticsSingleList(PageBean pb, HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        HashMap<String, PageBean> map = new HashMap<String, PageBean>();
        map.put("pb", this.logisticsSingleService.getLogisticsSingleList(pb, thirdId));
        pb.setUrl("logisticssingleThirdList.htm?n=" + n + "&l=" + l);
        ModelAndView mav = new ModelAndView("logisticsSingle/third_logisticsSingle_List");
        mav.addObject("map", map);
        mav.addObject(THIRDID, (Object)thirdId);
        return mav;
    }

    @RequestMapping(value={"/toAddThirdLogisticsSingle"})
    public ModelAndView toAddThirdLogisticsSingle(HttpServletRequest request) {
        Express expressmap = new Express();
        expressmap.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        ModelAndView mav = new ModelAndView("logisticsSingle/addThirdLogisticsSingle");
        mav.addObject("companys", (Object)this.expressInfoService.selectByStoreId(expressmap));
        return mav;
    }

    @RequestMapping(value={"/toUpdateThirdLogisticsSingle"})
    public ModelAndView toUpdateLogisticsSingle(Long logisticsSingleId, HttpServletRequest request) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        LogisticsSingle logisticsSingle = this.logisticsSingleService.selectLogisticsSingleById(logisticsSingleId, thirdId);
        return new ModelAndView("logisticsSingle/updateThirdLogisticsSingle").addObject("logisticsSingle", (Object)logisticsSingle);
    }

    @RequestMapping(value={"/updatelogisticssingles"})
    public ModelAndView updateLogisticsSingle(LogisticsSingle logisticsSingle) {
        if (this.logisticsSingleService.updateLogisticsSingle(logisticsSingle) > 0 && logisticsSingle.getThirdId() > 0L) {
            return new ModelAndView((View)new RedirectView("logisticssingleThirdList.htm?n=2&l=98"));
        }
        return null;
    }

    @RequestMapping(value={"/addThirdlogisticssingle"})
    public ModelAndView addLogisticsSingle(LogisticsSingle logisticsSingle, HttpServletRequest request) {
        logisticsSingle.setCreateTime(new Date());
        logisticsSingle.setDelFlag("0");
        logisticsSingle.setThirdId((Long)request.getSession().getAttribute(THIRDID));
        if (this.logisticsSingleService.addLogisticsSingle(logisticsSingle) > 0) {
            Customer cust;
            if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u7269\u6d41\u5355\u636e", "\u6dfb\u52a0\u7269\u6d41\u5355\u636e\uff0c\u7269\u6d41\u516c\u53f8\u540d\u79f0\uff1a" + logisticsSingle.getCompanyName() + "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u6dfb\u52a0\u7269\u6d41\u5355\u636e");
            }
            return new ModelAndView("redirect:logisticssingleThirdList.htm?n=2&l=98");
        }
        return new ModelAndView((View)new RedirectView("toAddThirdLogisticsSingle.htm"));
    }

    @RequestMapping(value={"/dellogisticssingles"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delLogisticsSingle(Long logisticsSingleId, HttpServletRequest request, Long thirdId) {
        Long thirdIdNew = thirdId;
        thirdIdNew = (Long)request.getSession().getAttribute(THIRDID);
        return this.logisticsSingleService.delLogisticsSingle(logisticsSingleId, thirdIdNew);
    }

    @RequestMapping(value={"/valiLogisticsSingle"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int valiLogisticsSingle(Long storeId) {
        int result = this.expressInfoService.selectDefaultRows(storeId);
        if (result > 0) {
            return 1;
        }
        return 0;
    }
}

