/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.service.ChannelGoodsService;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdChannelGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ThirdChannelGoodsController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String THIRDID = "thirdId";
    private static final String QUERYTHIRDCHANNELGOODS_HTM = "querythirdchannelgoods.htm?tempId=";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    @Resource(name="ThirdTempService")
    private ThirdTempService tempService;
    @Resource(name="ChannelGoodsService")
    private ChannelGoodsService channelGoodsService;
    @Resource(name="ChannelStoreyGoodsService")
    private ChannelStoreyGoodsService channelStoreyGoodsService;
    @Resource(name="ThirdOtherService")
    private ThirdOtherService thirdOtherService;

    @RequestMapping(value={"/querythirdchannelgoods"})
    public ModelAndView queryThirdChannelGoods(HttpServletRequest request, PageBean pb, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (thirdId != null && !"".equals(thirdId)) {
            map.put("sellThirdId", thirdId);
        }
        map.put("brandlist", this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute(THIRDID)));
        map.put("temp", temp);
        map.put("pb", this.channelGoodsService.selectchannelStoreyGoodsByParam(pb, tempId.toString(), null, thirdId));
        return new ModelAndView("temp/temp_hotgoods_list").addObject("map", map);
    }

    @RequestMapping(value={"/showthirdhotgoods"})
    public ModelAndView showThirdHotGoods(Long goodsProductId, Long tempId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView("temp/show_temp_hotgoods");
        SysTemp temp = this.tempService.getSystempById(tempId);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        if (null != goodsProductId) {
            ChannelStoreyGoods channelStoreyGoods = this.channelStoreyGoodsService.getChannelStoreyGoodsById(goodsProductId);
            mav.addObject("channelStoreyGoods", (Object)channelStoreyGoods);
        }
        if (thirdId != null) {
            mav.addObject("sellThirdId", (Object)thirdId);
        }
        mav.addObject("temp", (Object)temp);
        mav.addObject("brandlist", (Object)this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute(THIRDID)));
        return mav;
    }

    @RequestMapping(value={"/getHotGoodsById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStoreyGoods getHotGoodsById(Long hotGoodsId) {
        return this.channelStoreyGoodsService.getChannelStoreyGoodsById(hotGoodsId);
    }

    @RequestMapping(value={"/createthirdhotgoods"})
    public ModelAndView createThirdHotGoods(HttpServletRequest request, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYTHIRDCHANNELGOODS_HTM + tempId));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setCreateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setCreateUserId(loginUserId);
            }
            channelStoreyGoods.setTemp1(tempId.toString());
            int n = this.channelGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u7528\u6237\u540d:" + customerName));
                LOGGER.debug("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYTHIRDCHANNELGOODS_HTM + tempId));
        return mav;
    }

    @RequestMapping(value={"/updatethirdhotgoods"})
    public ModelAndView updateThirdHotGoods(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYTHIRDCHANNELGOODS_HTM + tempId));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setUpdateUserId(loginUserId);
            }
            int n = this.channelGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u7528\u6237\u540d:" + customerName));
                LOGGER.debug("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYTHIRDCHANNELGOODS_HTM + tempId));
        return mav;
    }

    @RequestMapping(value={"/deletethirdhotgoods"})
    public ModelAndView deleteThirdHotGoods(HttpServletRequest request, Long[] storeyGoodsIds, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelGoodsService.deleteChannelStoreyGoods(storeyGoodsIds[i], loginUserId);
        }
        return new ModelAndView((View)new RedirectView(QUERYTHIRDCHANNELGOODS_HTM + tempId));
    }
}

