/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempBrandController {
    private static final MyLogger LOGGER = new MyLogger(ThirdTempBrandController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOW_VIEW = "showThirdTempTrademark.htm?tempId=";
    private static final String LIST_VIEW = "queryThirdTempTrademarkByPageBean.htm?tempId=";
    private static final String THIRDID = "thirdId";
    @Resource(name="ThirdTempService")
    private ThirdTempService tempService;
    @Resource(name="ChannelTrademarkService")
    private ChannelTrademarkService channelTrademarkService;

    @RequestMapping(value={"/queryThirdTempTrademarkByPageBean"})
    public ModelAndView queryThirdTempTrademarkByPageBean(HttpServletRequest request, PageBean pb, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        return new ModelAndView("temp/temp_brand_list", "pb", (Object)this.channelTrademarkService.selectchannelTrademarkByParam(pb, null, tempId, null, null, null, thirdId)).addObject("temp", (Object)temp);
    }

    @RequestMapping(value={"/showThirdTempTrademark"})
    public ModelAndView showThirdTempTrademark(HttpServletRequest request, Long trademarkId, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        map.put("temp", temp);
        map.put(THIRDID, thirdId);
        if (null != trademarkId) {
            ChannelTrademark channelTrademark = this.channelTrademarkService.getChannelTrademarkById(trademarkId);
            map.put("channelTrademark", channelTrademark);
        }
        return new ModelAndView("temp/show_temp_brand", "map", map);
    }

    @RequestMapping(value={"/createThirdTempTrademark"})
    public ModelAndView createThirdTempTrademark(HttpServletRequest request, ChannelTrademark channelTrademark, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setCreateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setCreateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.saveChannelTrademark(channelTrademark);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u6a21\u677f\u54c1\u724c\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + tempId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u6a21\u677f\u54c1\u724c\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u6a21\u677f\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
        }
        return mav;
    }

    @RequestMapping(value={"/modifThirdTempTrademark"})
    public ModelAndView modifThirdTempTrademark(HttpServletRequest request, ChannelTrademark channelTrademark, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setUpdateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.updateChannelTrademark(channelTrademark);
            if (n > 0) {
                LOGGER.debug("\u4fee\u6539\u6a21\u677f\u54c1\u724c\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + tempId));
            } else {
                LOGGER.debug("\u4fee\u6539\u6a21\u677f\u54c1\u724c\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u6a21\u677f\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
        }
        return mav;
    }

    @RequestMapping(value={"/delThirdTempTrademark"})
    public ModelAndView delThirdTempTrademark(HttpServletRequest request, Long[] trademarkIds, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < trademarkIds.length; ++i) {
            this.channelTrademarkService.deleteChannelTrademark(trademarkIds[i], loginUserId);
        }
        return new ModelAndView((View)new RedirectView(LIST_VIEW + tempId));
    }
}

