/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.temp.bean.ClassifyBar;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ClassifyBarService;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.third.goods.service.ThirdCateService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempClassifyBarController {
    private static final MyLogger LOGGER = new MyLogger(ThirdTempClassifyBarController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String THIRDID = "thirdId";
    private static final String JUMPFORTHIRDTEMPCLASSIFYBARVIEW_HTM = "jumpForThirdTempClassifyBarView.htm?tempId=";
    @Resource(name="ThirdTempService")
    private ThirdTempService tempService;
    @Resource(name="ClassifyBarService")
    private ClassifyBarService classifyBarService;
    @Resource(name="ThirdCateService1")
    private ThirdCateService goodsCateService;

    @RequestMapping(value={"/jumpForThirdTempClassifyBarView"})
    public ModelAndView jumpForThirdTempClassifyBarView(HttpServletRequest request, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        ModelAndView modelAndView = new ModelAndView("temp/temp_classifybar_list");
        modelAndView.addObject("temp", (Object)temp);
        return modelAndView;
    }

    @RequestMapping(value={"/toThirdTempClassifyBar"})
    public ModelAndView toThirdTempClassifyBar(HttpServletRequest request, Long tempId) {
        ModelAndView mav = new ModelAndView();
        try {
            SysTemp temp = this.tempService.getSystempById(tempId);
            mav.addObject("temp", (Object)temp);
            mav.setViewName("temp/temp_classifybar_list_new");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u5206\u7c7b\u5bfc\u822a\u5217\u8868\u89c6\u56fe\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/queryThirdTempClassifyBar"}, produces={"application/json;charset=UTF-8"})
    public PageBean queryThirdTempClassifyBar(HttpServletRequest request, PageBean pb, Long tempId) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        return this.classifyBarService.selectClassifyBarByParam(pb, tempId, null, thirdId.toString());
    }

    @RequestMapping(value={"/showThirdTempClassifyBar"})
    public ModelAndView showThirdTempClassifyBar(HttpServletRequest request, Long classifyBarId, Long tempId, Long parentId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List cateList = null;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        if (null != classifyBarId) {
            ClassifyBar classifyBar = this.classifyBarService.getClassifyBarById(classifyBarId);
            map.put("classifyBar", classifyBar);
            if (null != classifyBar.getParentId() && classifyBar.getParentId() > 0L) {
                Long parentIdCate = this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGoodsCatId();
                cateList = this.goodsCateService.getThirdCateByParentId(parentIdCate, thirdId);
            } else {
                cateList = this.goodsCateService.getThirdCateByParentId(Long.valueOf(0L), thirdId);
            }
        } else if (null != parentId) {
            Long parentIdCate = this.classifyBarService.getClassifyBarById(parentId).getGoodsCatId();
            cateList = this.goodsCateService.getThirdCateByParentId(parentIdCate, thirdId);
        } else {
            cateList = this.goodsCateService.getThirdCateByParentId(Long.valueOf(0L), thirdId);
        }
        map.put("cateList", cateList);
        map.put("tempId", tempId);
        map.put("parentId", parentId);
        map.put(THIRDID, thirdId);
        return new ModelAndView("temp/show_temp_classifybar", "map", map);
    }

    @RequestMapping(value={"/createThirdTempClassifyBar"})
    public ModelAndView createThirdTempClassifyBar(HttpServletRequest request, ClassifyBar classifyBar) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        if (null == classifyBar.getParentId()) {
            classifyBar.setGrade(Integer.valueOf(1));
        } else {
            classifyBar.setGrade(Integer.valueOf(this.classifyBarService.getClassifyBarById(classifyBar.getParentId()).getGrade() + 1));
        }
        classifyBar.setCreateUserId(loginUserId);
        this.classifyBarService.saveClassifyBar(classifyBar);
        return new ModelAndView((View)new RedirectView(JUMPFORTHIRDTEMPCLASSIFYBARVIEW_HTM + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateThirdTempClassifyBar"})
    public ModelAndView updateThirdTempClassifyBar(HttpServletRequest request, ClassifyBar classifyBar) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        classifyBar.setUpdateUserId(loginUserId);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        classifyBar.setTemp1(thirdId.toString());
        this.classifyBarService.updateClassifyBar(classifyBar);
        return new ModelAndView((View)new RedirectView(JUMPFORTHIRDTEMPCLASSIFYBARVIEW_HTM + classifyBar.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteThirdTempClassifyBar"})
    public ModelAndView deleteThirdTempClassifyBar(HttpServletRequest request, Long[] classifyBarId, Long tempId) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        for (int i = 0; i < classifyBarId.length; ++i) {
            this.classifyBarService.deleteClassBarById(classifyBarId[i], thirdId);
        }
        return new ModelAndView((View)new RedirectView(JUMPFORTHIRDTEMPCLASSIFYBARVIEW_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/getClassifyBarById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ClassifyBar getClassifyBarById(Long classifyBarId) {
        return this.classifyBarService.getClassifyBarById(classifyBarId);
    }
}

