/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempStoreyGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ThirdTempStoreyGoodsController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOW_VIEW = "showThirdTempStoreyGoods.htm?storeyId=";
    private static final String LIST_VIEW = "queryThirdTemplStoreyGoodsByPageBean.htm?storeyId=";
    @Resource(name="ChannelStoreyService")
    private ChannelStoreyService channelStoreyService;
    @Resource(name="ChannelStoreyGoodsService")
    private ChannelStoreyGoodsService channelStoreyGoodsService;
    @Resource(name="ThirdOtherService")
    private ThirdOtherService thirdOtherService;

    @RequestMapping(value={"/queryThirdTemplStoreyGoodsByPageBean"})
    public ModelAndView queryThirdTempStoreyGoodsByPageBean(HttpServletRequest request, PageBean pb, Long storeyId) {
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelStoreyGoodsService.selectchannelStoreyGoodsByParam(pb, storeyId, null, null));
        map.put("channelStorey", channelStorey);
        map.put("brandlist", this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute("thirdId")));
        return new ModelAndView("temp/temp_storeygoods_list", "map", map);
    }

    @RequestMapping(value={"/showThirdTempStoreyGoods"})
    public ModelAndView showThirdTempStoreyGoods(Long channelStoreyGoodsproductId, Long storeyId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        if (null != channelStoreyGoodsproductId) {
            ChannelStoreyGoods channelStoreyGoods = this.channelStoreyGoodsService.getChannelStoreyGoodsById(channelStoreyGoodsproductId);
            mav.addObject("channelStoreyGoods", (Object)channelStoreyGoods);
        }
        mav.addObject("channelStorey", (Object)channelStorey);
        mav.addObject("brandlist", (Object)this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute("thirdId")));
        mav.setViewName("temp/show_temp_storeygoods");
        return mav;
    }

    @RequestMapping(value={"/getChannelStoreyGoodsById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStoreyGoods getChannelStoreyGoodsById(Long channelGoodsStoreyId) {
        return this.channelStoreyGoodsService.getChannelStoreyGoodsById(channelGoodsStoreyId);
    }

    @RequestMapping(value={"/createThirdTempStoreyGoods"})
    public ModelAndView createThirdTempStoreyGoods(HttpServletRequest request, HttpServletResponse response, ChannelStoreyGoods channelStoreyGoods, Long storeyId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setCreateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setCreateUserId(loginUserId);
            }
            int n = this.channelStoreyGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + storeyId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_VIEW + storeyId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_VIEW + storeyId));
        }
        return mav;
    }

    @RequestMapping(value={"/updateThirdTempStoreyGoods"})
    public ModelAndView updateThirdTempStoreyGoods(HttpServletRequest request, HttpServletResponse response, ChannelStoreyGoods channelStoreyGoods, Long storeyId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setUpdateUserId(loginUserId);
            }
            int n = this.channelStoreyGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + storeyId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_VIEW + storeyId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_VIEW + storeyId));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteThirdTempStoreyGoods"})
    public ModelAndView deleteThirdTempStoreyGoods(HttpServletRequest request, Long[] storeyGoodsIds, Long storeyId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelStoreyGoodsService.deleteChannelStoreyGoods(storeyGoodsIds[i], loginUserId);
        }
        return new ModelAndView((View)new RedirectView(LIST_VIEW + storeyId));
    }
}

