/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempStoreyTagGoodsController {
    private static final String LIST_ACTION = "queryThirdTemplStoreyTagGoodsByPageBean.htm?storeyTagId=";
    private static final String SHOW_ACTION = "showThirdTempStoreyTagGoods.htm?storeyTagId=";
    private static final String LOGINUSERID = "loginUserId";
    private static final MyLogger LOGGER = new MyLogger(ThirdTempStoreyTagGoodsController.class);
    @Resource(name="ChannelStoreyService")
    private ChannelStoreyService channelStoreyService;
    @Resource(name="ChannelStoreyTagService")
    private ChannelStoreyTagService storeyTagService;
    @Resource(name="ChannelStoreyGoodsService")
    private ChannelStoreyGoodsService channelStoreyGoodsService;
    @Resource(name="ThirdOtherService")
    private ThirdOtherService thirdOtherService;

    @RequestMapping(value={"/queryThirdTemplStoreyTagGoodsByPageBean"})
    public ModelAndView queryThirdTempStoreyTagGoodsByPageBean(HttpServletRequest request, PageBean pb, Long storeyTagId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ChannelStoreyTag storeyTag = this.storeyTagService.getChannelStoreyTagById(storeyTagId);
        map.put("storeyTag", this.storeyTagService.getChannelStoreyTagById(storeyTagId));
        map.put("channelStorey", this.channelStoreyService.getChannelStoreyById(storeyTag.getStoreyId()));
        map.put("pb", this.channelStoreyGoodsService.selectchannelStoreyGoodsByParam(pb, null, storeyTagId, null));
        map.put("brandlist", this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute("thirdId")));
        return new ModelAndView("temp/temp_storeytaggoods_list", "map", map);
    }

    @RequestMapping(value={"/showThirdTempStoreyTagGoods"})
    public ModelAndView showThirdTempStoreyTagGoods(Long storeyTagGoodsId, Long storeyTagId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        ChannelStoreyTag storeyTag = this.storeyTagService.getChannelStoreyTagById(storeyTagId);
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyTag.getStoreyId());
        mav.addObject("channelStorey", (Object)channelStorey);
        mav.addObject("storeyTag", (Object)storeyTag);
        if (null != storeyTagGoodsId) {
            ChannelStoreyGoods channelStoreyGoods = this.channelStoreyGoodsService.getChannelStoreyGoodsById(storeyTagGoodsId);
            mav.addObject("channelStoreyGoods", (Object)channelStoreyGoods);
        }
        mav.addObject("brandlist", (Object)this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute("thirdId")));
        mav.setViewName("temp/show_temp_storeytaggoods");
        return mav;
    }

    @RequestMapping(value={"/getTagGoodsInfoById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStoreyGoods getTagGoodsById(Long tagGoodsId) {
        return this.channelStoreyGoodsService.getChannelStoreyGoodsById(tagGoodsId);
    }

    @RequestMapping(value={"/createThirdTempStoreyTagGoods"})
    public ModelAndView createThirdTempStoreyTagGoods(HttpServletRequest request, HttpServletResponse response, ChannelStoreyGoods channelStoreyGoods, Long storeyTagId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setCreateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setCreateUserId(loginUserId);
            }
            int n = this.channelStoreyGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_ACTION + storeyTagId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION + storeyTagId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION + storeyTagId));
        }
        return mav;
    }

    @RequestMapping(value={"/updateThirdTempStoreyTagGoods"})
    public ModelAndView updateThirdTempStoreyTagGoods(HttpServletRequest request, ChannelStoreyGoods channelStoreyGoods, Long storeyTagId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setUpdateUserId(loginUserId);
            }
            int n = this.channelStoreyGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_ACTION + storeyTagId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION + storeyTagId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION + storeyTagId));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteThirdTempStoreyTagGoods"})
    public ModelAndView deleteThirdTempStoreyTagGoods(HttpServletRequest request, Long[] storeyGoodsIds, Long storeyTagId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelStoreyGoodsService.deleteChannelStoreyGoods(storeyGoodsIds[i], loginUserId);
        }
        return new ModelAndView((View)new RedirectView(LIST_ACTION + storeyTagId));
    }
}

