/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.thirdproject.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.thirdproject.bean.ThirdProject;
import com.qianjiang.thirdproject.service.ThirdProjectService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdProjectController {
    private static final MyLogger LOGGER = new MyLogger(ThirdProjectController.class);
    private static final String THIRDID = "thirdId";
    private static final String QUERYPROJECTLIST_HTM = "queryProjectList.htm";
    @Resource(name="ThirdProjectService")
    private ThirdProjectService thirdProjectService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;

    @RequestMapping(value={"queryProjectList"})
    public ModelAndView queryProjectList(HttpServletRequest request, PageBean pageBean, ThirdProject thirdProject, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        thirdProject.setThirdId(thirdId);
        return new ModelAndView("project/thirdproject").addObject("pageBean", (Object)this.thirdProjectService.queryThirdProjectByPage(pageBean, thirdProject)).addObject("findBasicSet", (Object)this.basicSetService.findBasicSet());
    }

    @RequestMapping(value={"toAddThirdProject"})
    public ModelAndView toAddThirdProject() {
        return new ModelAndView("project/addthirdproject");
    }

    @RequestMapping(value={"addThirdProject"})
    public ModelAndView addThirdProject(HttpServletRequest request, ThirdProject thirdProject) {
        Customer cust;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        thirdProject.setThirdId(thirdId);
        this.thirdProjectService.addThirdProject(thirdProject);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u5546\u5bb6\u4e13\u9898", "\u6dfb\u52a0\u5546\u5bb6\u4e13\u9898\uff0c\u4e13\u9898\u540d\u79f0\u3010" + thirdProject.getThirdProjectName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u6dfb\u52a0\u5546\u5bb6\u4e13\u9898");
        }
        return new ModelAndView((View)new RedirectView(QUERYPROJECTLIST_HTM));
    }

    @RequestMapping(value={"deleteThirdProject"})
    public ModelAndView deleteThirdProject(HttpServletRequest request, Long thirdProjectId) {
        Customer cust;
        ThirdProject thirdProject = this.thirdProjectService.selectProjectById(thirdProjectId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thirdProjectId", thirdProjectId);
        map.put(THIRDID, request.getSession().getAttribute(THIRDID));
        this.thirdProjectService.updateDelflagstatu(map);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u5220\u9664\u5546\u5bb6\u4e13\u9898", "\u5220\u9664\u5546\u5bb6\u4e13\u9898\uff0c\u4e13\u9898\u540d\u79f0\u3010" + thirdProject.getThirdProjectName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u5220\u9664\u5546\u5bb6\u4e13\u9898");
        }
        return new ModelAndView((View)new RedirectView(QUERYPROJECTLIST_HTM));
    }

    @RequestMapping(value={"toUpdateThirdProject"})
    public ModelAndView toUpdateThirdProject(Long thirdProjectId) {
        return new ModelAndView("project/updatethirdproject").addObject("thirdProject", (Object)this.thirdProjectService.selectProjectById(thirdProjectId));
    }

    @RequestMapping(value={"/getProjectInfoById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ThirdProject getProjectInfoById(Long thirdProjectId) {
        return this.thirdProjectService.selectProjectById(thirdProjectId);
    }

    @RequestMapping(value={"updateThirdProject"})
    public ModelAndView updateThirdProject(HttpServletRequest request, ThirdProject thirdProject) {
        Customer cust;
        thirdProject.setThirdId((Long)request.getSession().getAttribute(THIRDID));
        this.thirdProjectService.updateThirdProject(thirdProject);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u5546\u5bb6\u4e13\u9898", "\u4fee\u6539\u5546\u5bb6\u4e13\u9898\uff0c\u65b0\u4e13\u9898\u540d\u79f0\u3010" + thirdProject.getThirdProjectName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u4fee\u6539\u5546\u5bb6\u4e13\u9898");
        }
        return new ModelAndView((View)new RedirectView(QUERYPROJECTLIST_HTM));
    }
}

