/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.findpwd.controller;

import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.findpwd.service.FindPwdService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.findpwd.util.FindPwdUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class FindPwdController {
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="FindPwdServiceM")
    private FindPwdService findPwdService;
    private static final MyLogger LOGGER = new MyLogger(FindPwdController.class);
    private static final String TITLE = "\u5085\u751f\u73e0\u5b9d\u90ae\u7bb1\u9a8c\u8bc1\u7801";

    @RequestMapping(value={"/m/valididentity"})
    public ModelAndView toCheckUserIndentity(HttpServletRequest request, String code, ModelMap model) {
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        HttpSession session = request.getSession();
        session.setAttribute("upPass", (Object)token);
        session.setMaxInactiveInterval(600);
        model.put((Object)"token", (Object)token);
        return new ModelAndView("login/forgotpassword");
    }

    @RequestMapping(value={"/m/govalididentity"})
    public ModelAndView checkUserIndentity(HttpServletRequest request, String code) {
        try {
            if (FindPwdUtil.checkCode(request, code)) {
                return new ModelAndView("redirect:/resetpassword.html");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        return new ModelAndView("redirect:/customercenter.html");
    }

    @RequestMapping(value={"/m/resetpassword"})
    public ModelAndView toResetUserPwd(HttpServletRequest request, String code) {
        try {
            if (FindPwdUtil.checkSessionCode(request)) {
                return new ModelAndView("customer/findpwd2");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        return new ModelAndView("redirect:/customercenter.html");
    }

    @RequestMapping(value={"/m/goresetpassword"})
    public ModelAndView resetUserPwd(HttpServletRequest request, String userKey) {
        try {
            if (FindPwdUtil.checkSessionCode(request)) {
                String userMobile = (String)request.getSession().getAttribute("userMobile");
                this.customerService.updateCusomerPwd(userMobile, userKey);
                return new ModelAndView("redirect:/success.html");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        return new ModelAndView("redirect:/customercenter.html");
    }

    @RequestMapping(value={"/m/success"})
    public ModelAndView resetUserPwd(HttpServletRequest request) {
        try {
            if (FindPwdUtil.checkSuccessCode(request)) {
                return new ModelAndView("customer/findpwd3");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        return new ModelAndView("redirect:/customercenter.html");
    }

    @RequestMapping(value={"/updatePwdMobile"})
    @ResponseBody
    public Object forGetPassword(HttpServletRequest request, HttpServletResponse response, String code, String mobile, String newpassword, String token) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> param = new HashMap<String, String>();
        try {
            String sessonCode = (String)request.getSession().getAttribute("UpdatePassCode");
            String userMobile = (String)request.getSession().getAttribute("UpdatePassMobile");
            String userMobilex = (String)request.getSession().getAttribute("userMobile");
            param.put("sessonCode", sessonCode);
            param.put("userMobile", userMobile);
            param.put("userMobilex", userMobilex);
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            result.put("token", uuid);
            if (!(StringUtils.isEmpty((String)code) || StringUtils.isEmpty((String)mobile) || StringUtils.isEmpty((String)newpassword) || StringUtils.isEmpty((String)token))) {
                HttpSession session = request.getSession();
                String sessionToken = (String)session.getAttribute("upPass");
                session.setAttribute("upPass", (Object)uuid);
                session.setMaxInactiveInterval(600);
                if (token.equals(sessionToken)) {
                    result.put("status", this.findPwdService.forGetPwd(param, code, mobile, newpassword));
                    Cookie cookieName = new Cookie("_mall_newMobile_username", null);
                    Cookie cookiePassword = new Cookie("_mall_newMobile_password", null);
                    cookieName.setMaxAge(-1);
                    cookieName.setPath("/");
                    cookiePassword.setMaxAge(-1);
                    cookiePassword.setPath("/");
                    response.addCookie(cookieName);
                    response.addCookie(cookiePassword);
                    return result;
                }
            }
            result.put("status", "0");
            return result;
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            return new ModelAndView("redirect:/customercenter.html");
        }
    }

    @RequestMapping(value={"/sendcodepwd"})
    @ResponseBody
    public int sendcodeFindPwd(HttpServletRequest request, HttpServletResponse response, String mobile) throws IOException {
        if (!StringUtils.isEmpty((String)mobile)) {
            int exist = this.findPwdService.checkCustomerExists(mobile);
            if (exist == 2) {
                return 2;
            }
            request.getSession().removeAttribute("PATCHCA");
            Map reslutMap = this.customerService.sendPost(mobile, "UpdatePassCode", "UpdatePassMobile");
            HttpSession session = request.getSession();
            session.setAttribute("mcCode", reslutMap.get("mcCode"));
            session.setAttribute("userMobile", reslutMap.get("userMobile"));
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"/sendEmail"})
    public static void sendEmail(String receiver) {
        Properties properties = new Properties();
        ResourceBundle bundle = ResourceBundle.getBundle("email");
        String host = bundle.getString("mail.host");
        String sendFrom = bundle.getString("mail.from");
        final String username = bundle.getString("username");
        final String password = bundle.getString("password");
        properties.setProperty("mail.smtp.host", host);
        properties.setProperty("mail.transport.protocol", "smtp");
        properties.setProperty("mail.smtp.auth", "true");
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
        Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)authenticator);
        session.setDebug(true);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setSubject(TITLE);
            message.setFrom((Address)new InternetAddress(sendFrom));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(receiver));
            message.setContent((Object)FindPwdController.getCode(), "text/html;charset=UTF-8");
            Transport.send((Message)message);
            LOGGER.info((Object)"\u53d1\u9001\u90ae\u4ef6\u6210\u529f");
        }
        catch (MessagingException e) {
            LOGGER.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static String getCode() {
        int code = (int)(Math.random() * 9000.0 + 100000.0);
        return code + "";
    }

    @RequestMapping(value={"/mailverify"})
    public ModelAndView mailsend() {
        return new ModelAndView("login/mailverify");
    }
}

