/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.order.controller;

import com.alipay.api.internal.util.StringUtils;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.service.PayService;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.third.audit.service.StoreInfoService;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.utils.SecurityUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/mobileOrderController"})
public class MobileOrderController {
    private Logger logger = Logger.getLogger(MobileOrderController.class);
    @Autowired
    private OrderService OrderService;
    @Autowired
    private DistrictService districtService;
    @Resource(name="payService")
    private PayService payService;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Autowired
    private StoreInfoService storeInfoService;

    @RequestMapping(value={"/toOrderPayPage"})
    public ModelAndView toOrderPayPage(HttpServletRequest request, String[] orderIds, ModelMap modelMap) {
        if (orderIds != null && orderIds.length > 0) {
            BigDecimal orderPrice = new BigDecimal(0);
            String orderCode = "";
            String orderType = "one";
            for (String orderId : orderIds) {
                if (StringUtils.isEmpty((String)orderId)) continue;
                modelMap.put((Object)"orderId", (Object)orderId);
                Order order = this.OrderService.orderDetail(Long.valueOf(orderId));
                if (null == order || !"0".equals(order.getOrderStatus())) continue;
                if (orderIds.length == 1) {
                    orderPrice = order.getOrderPrice();
                    orderCode = order.getOrderCode();
                    continue;
                }
                orderType = "all";
                orderCode = order.getOrderOldCode();
                orderPrice = orderPrice.add(order.getOrderPrice());
            }
            String orderPrices = request.getParameter("orderPrice");
            orderPrice = orderPrices == null || orderPrices == "" ? orderPrice : new BigDecimal(orderPrices);
            modelMap.put((Object)"orderPrice", (Object)orderPrice);
            modelMap.put((Object)"orderCode", (Object)orderCode);
            modelMap.put((Object)"orderType", (Object)orderType);
        }
        Pay alipay = this.payService.findByPayId(Long.valueOf(25L));
        Pay wxpay = this.payService.findByPayId(Long.valueOf(37L));
        ArrayList<Pay> pays = new ArrayList<Pay>();
        pays.add(alipay);
        pays.add(wxpay);
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo custInfo = this.customerService.selectByPrimaryKey(customerId);
        BigDecimal userTotalPrice = custInfo.getUserTotalPrice();
        String money = "";
        money = userTotalPrice == null && userTotalPrice.toString().equals("0.00") ? "0.00" : userTotalPrice.toString();
        ModelAndView view = new ModelAndView("customer/orderPay_ct");
        view.addObject("pays", pays);
        view.addObject("money", (Object)money);
        view.addObject("payMixFlag", (Object)custInfo.getPaypwdFlag());
        return view;
    }

    @RequestMapping(value={"/yzPaypwd"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int yzPaypwd(HttpServletRequest request, String pwd) {
        int flag = 0;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo custInfo = this.customerService.selectByPrimaryKey(customerId);
        String encodePwd = SecurityUtil.getStoreLogpwd((String)custInfo.getUniqueCode(), (String)pwd, (String)custInfo.getSaltVal());
        if (encodePwd.equals(custInfo.getPayPassword())) {
            flag = 1;
        }
        return flag;
    }

    @RequestMapping(value={"toPayResultPages"})
    public ModelAndView toPayResultPages(HttpServletRequest request, ModelMap modelMap) {
        ModelAndView view = new ModelAndView("order/payFail_ct");
        ArrayList list = new ArrayList();
        String orderPrice = "0";
        try {
            String orderId = request.getParameter("orderId");
            this.logger.debug((Object)("----------------\u5f00\u59cb\u6267\u884ctoPayResultPages--------orderId[" + orderId + "--------------]"));
            if (!StringUtils.isEmpty((String)orderId)) {
                StoreInfo storeInfo;
                Long storeId;
                AddressUtil address;
                Order order = this.OrderService.orderDetail(Long.valueOf(orderId));
                if (order != null && "1".equals(order.getOrderStatus())) {
                    view = new ModelAndView("order/paySuccess_ct");
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("orderId", order.getOrderId());
                orderPrice = order.getOrderPrice().toString();
                result.put("orderDistributedType", order.getOrderDistributedType());
                result.put("shippingPerson", order.getShippingPerson());
                result.put("shippingMobile", order.getShippingMobile());
                result.put("addr", order.getShippingProvince() + order.getShippingCity() + order.getShippingCounty() + order.getShippingAddress());
                String storeAddress = "";
                Long id = order.getShippingCountyId();
                if (id != null && null != (address = this.districtService.queryAddressNameByDistrictId(id))) {
                    storeAddress = storeAddress + address.getProvinceName() + address.getCityName() + address.getDistrictName();
                }
                if ((storeId = order.getBusinessId()) != null && null != (storeInfo = this.storeInfoService.selectByPrimaryKey(storeId))) {
                    storeAddress = storeAddress + storeAddress + " " + storeInfo.getStoreName();
                }
                result.put("toAddr", storeAddress);
                list.add(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject("list", list);
        view.addObject("orderPrice", (Object)orderPrice);
        this.logger.debug((Object)"----------------\u7ed3\u675f\u6267\u884ctoPayResultPages--------");
        return view;
    }

    @Resource(name="payService")
    public void setPayService(PayService payService) {
        this.payService = payService;
    }

    public PayService getPayService() {
        return this.payService;
    }
}

