/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.weixin.util;

import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UtilDate;
import com.qianjiang.wap.weixin.util.WeiXinUtil;
import com.qianjiang.wap.weixin.util.WxSign;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.springframework.stereotype.Service;

@Service(value="wxClientCredential")
public class WxClientCredential {
    private static final MyLogger LOGGER = new MyLogger(WxClientCredential.class);
    private static final String EX_JSAPITICKET = "Sedding jsapiTicket request failed!";
    private static final String EX_JSAPIACCESSTOKEN = "Sedding jsapiAccessToken request failed!";
    private static final String CURR_ACCESSTOKEN_INFO = "  \u5f53\u524d\u516c\u4f17\u53f7\u552f\u4e00\u51ed\u8bc1accessToken: ";
    private static final String CURR_EXPIRESIN_INFO = "  \u5f53\u524d\u51ed\u8bc1\u6709\u6548\u65f6\u95f4,\u5355\u4f4d \u79d2expiresIn: ";
    private static final String CURR_JSAPITICKET_INFO = "  \u5f53\u524d\u4e34\u65f6\u7968\u636ejsapiTicket: ";
    private String accessToken;
    private int expiresIn;
    private Date createTimeTicket;
    private String jsapiTicket;
    private int advanceTime = 600;
    @Resource(name="authService")
    private AuthService authService;

    public String getJsapiTicket() {
        return this.jsapiTicket;
    }

    public void setJsapiTicket(String jsapiTicket) {
        this.jsapiTicket = jsapiTicket;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Date getCreateTimeTicket() {
        return this.createTimeTicket;
    }

    public void setCreateTimeTicket(Date createTimeTicket) {
        this.createTimeTicket = createTimeTicket;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public int getAdvanceTime() {
        return this.advanceTime;
    }

    public void setAdvanceTime(int advanceTime) {
        this.advanceTime = advanceTime;
    }

    public void init() {
        this.getWxAccessToken();
        this.getWxJsapiTicket();
    }

    public void getWxAccessToken() {
        Auth auth = this.authService.findAuthByAuthType("9");
        if (auth != null && auth.getAuthClientId() != null && auth.getAuthClientSecret() != null) {
            String getAccessTokenURL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + auth.getAuthClientId() + "&secret=" + auth.getAuthClientSecret();
            GetMethod getMethod = new GetMethod(getAccessTokenURL);
            HttpClient httpTokenClient = new HttpClient();
            getMethod.getParams().setContentCharset("utf-8");
            String tokenRespons = "";
            try {
                httpTokenClient.executeMethod((HttpMethod)getMethod);
                tokenRespons = getMethod.getResponseBodyAsString();
                this.accessToken = WeiXinUtil.getWxAcessToken(tokenRespons);
                this.expiresIn = WeiXinUtil.getWxAccessTokenExpiresIn(tokenRespons);
                LOGGER.info((Object)(CURR_ACCESSTOKEN_INFO + this.accessToken + CURR_EXPIRESIN_INFO + this.expiresIn));
            }
            catch (Exception e) {
                LOGGER.info((Object)EX_JSAPIACCESSTOKEN);
            }
        }
    }

    public void getWxJsapiTicket() {
        String getJsapiTicket = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + this.accessToken + "&type=jsapi";
        PostMethod postMethod = new PostMethod(getJsapiTicket);
        HttpClient httpTicketClient = new HttpClient();
        postMethod.getParams().setContentCharset("utf-8");
        String ticketResponse = "";
        try {
            httpTicketClient.executeMethod((HttpMethod)postMethod);
            ticketResponse = postMethod.getResponseBodyAsString();
            this.jsapiTicket = WeiXinUtil.getWxJsapiTicket(ticketResponse);
            this.createTimeTicket = new Date();
            LOGGER.info((Object)(CURR_JSAPITICKET_INFO + this.jsapiTicket));
        }
        catch (Exception e) {
            LOGGER.info((Object)EX_JSAPITICKET);
        }
    }

    public Map<String, String> getWxConfigInfo(String url) throws Exception {
        Auth auth = this.authService.findAuthByAuthType("9");
        if (UtilDate.intervalSecondToNow((Date)this.createTimeTicket) > this.expiresIn - this.advanceTime) {
            this.init();
        }
        Map<String, String> configMap = WxSign.sign(this.jsapiTicket, url);
        configMap.put("appId", auth.getAuthClientId());
        return configMap;
    }
}

