/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.query;

import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.IKSegmenter;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.Lexeme;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class SWMCQueryBuilder {
    private static final Logger LOGGER = Logger.getLogger(SWMCQueryBuilder.class);

    private SWMCQueryBuilder() {
    }

    public static Query create(String fieldName, String keywords, boolean quickMode) {
        if (fieldName == null || keywords == null) {
            throw new IllegalArgumentException("\u53c2\u6570 fieldName \u3001 keywords \u4e0d\u80fd\u4e3anull.");
        }
        List<Lexeme> lexemes = SWMCQueryBuilder.doAnalyze(keywords);
        return SWMCQueryBuilder.getSWMCQuery(fieldName, lexemes, quickMode);
    }

    private static List<Lexeme> doAnalyze(String keywords) {
        ArrayList<Lexeme> lexemes = new ArrayList<Lexeme>();
        IKSegmenter ikSeg = new IKSegmenter((Reader)new StringReader(keywords), true);
        try {
            Lexeme l = null;
            while ((l = ikSeg.next()) != null) {
                lexemes.add(l);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return lexemes;
    }

    private static Query getSWMCQuery(String fieldName, List<Lexeme> lexemes, boolean quickMode) {
        StringBuilder keywordBuffer = new StringBuilder();
        StringBuilder keywordBufferShort = new StringBuilder();
        int lastLexemeLength = 0;
        int lastLexemeEnd = -1;
        int shortCount = 0;
        int totalCount = 0;
        for (Lexeme l : lexemes) {
            totalCount += l.getLength();
            if (l.getLength() > 1) {
                keywordBufferShort.append(' ').append(l.getLexemeText());
                shortCount += l.getLength();
            }
            if (lastLexemeLength == 0) {
                keywordBuffer.append(l.getLexemeText());
            } else if (lastLexemeLength == 1 && l.getLength() == 1 && lastLexemeEnd == l.getBeginPosition()) {
                keywordBuffer.append(l.getLexemeText());
            } else {
                keywordBuffer.append(' ').append(l.getLexemeText());
            }
            lastLexemeLength = l.getLength();
            lastLexemeEnd = l.getEndPosition();
        }
        QueryParser qp = new QueryParser(Version.LUCENE_47, fieldName, (Analyzer)new StandardAnalyzer(Version.LUCENE_47));
        qp.setDefaultOperator(QueryParser.AND_OPERATOR);
        qp.setAutoGeneratePhraseQueries(true);
        if (quickMode && (float)shortCount * 1.0f / (float)totalCount > 0.5f) {
            try {
                return qp.parse(keywordBufferShort.toString());
            }
            catch (ParseException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (keywordBuffer.length() > 0) {
            try {
                return qp.parse(keywordBuffer.toString());
            }
            catch (ParseException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

