/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.image.service.impl;

import com.qianjiang.image.bean.InfoImageClassify;
import com.qianjiang.image.dao.InfoImageClassifyMapper;
import com.qianjiang.image.service.InfoImageClassifyService;
import com.qianjiang.image.vo.InfoImageClassifyVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="InfoImageClassifyService")
public class InfoImageClassifyServiceImpl
implements InfoImageClassifyService {
    private static final MyLogger LOGGER = new MyLogger(InfoImageClassifyServiceImpl.class);
    private InfoImageClassifyMapper infoImageClassifyMapper;

    @Override
    public int deleteInfoImageClassify(Long classifyId) {
        try {
            InfoImageClassify infoImageClassify = this.infoImageClassifyMapper.selectByPrimaryKey(classifyId);
            infoImageClassify.setDelflag("1");
            infoImageClassify.setUpdateDate(new Date());
            return this.infoImageClassifyMapper.updateByPrimaryKeySelective(infoImageClassify);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u56fe\u7247\u7ba1\u7406\u7c7b\u578b\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int saveInfoImageClassify(InfoImageClassify record) {
        try {
            if (record.getParentId() == -1L) {
                record.setGrade(1);
            } else {
                record.setGrade(this.infoImageClassifyMapper.selectByPrimaryKey(record.getParentId()).getGrade() + 1);
            }
            Date date = new Date();
            record.setCreateDate(date);
            record.setUpdateDate(date);
            return this.infoImageClassifyMapper.insertSelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u56fe\u7247\u7ba1\u7406\u7c7b\u578b\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int updateInfoImageClassify(InfoImageClassify record) {
        try {
            if (record.getParentId() == -1L) {
                record.setGrade(1);
            } else if (this.infoImageClassifyMapper.selectByPrimaryKey(record.getParentId()) != null) {
                record.setGrade(this.infoImageClassifyMapper.selectByPrimaryKey(record.getParentId()).getGrade() + 1);
            } else {
                record.setGrade(1);
            }
            record.setUpdateDate(new Date());
            if (record.getParentId().equals(record.getClassifyId())) {
                record.setParentId(null);
            }
            return this.infoImageClassifyMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u56fe\u7247\u7ba1\u7406\u7c7b\u578b\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public InfoImageClassify getInfoImageClassifyById(Long classifyId) {
        InfoImageClassify infoImageClassify = null;
        try {
            infoImageClassify = this.infoImageClassifyMapper.selectByPrimaryKey(classifyId);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636eID\u67e5\u8be2\u56fe\u7247\u7ba1\u7406\u7c7b\u578b\u9519\u8bef:", e);
        }
        return infoImageClassify;
    }

    @Override
    public PageBean selectImageClassifyByParam(PageBean pb) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            pb.setRows(this.infoImageClassifyMapper.selectImageClassifyCountByParam());
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.infoImageClassifyMapper.selectImageClassifyByParam(map));
            return pb;
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u56fe\u7247\u7ba1\u7406\u5206\u7c7b\u5217\u8868\u9519\u8bef:", e);
            return null;
        }
    }

    @Override
    public List<InfoImageClassify> selectAllImageClassify() {
        return this.infoImageClassifyMapper.selectAllImageClassify();
    }

    public InfoImageClassifyMapper getInfoImageClassifyMapper() {
        return this.infoImageClassifyMapper;
    }

    @Resource(name="InfoImageClassifyMapper")
    public void setInfoImageClassifyMapper(InfoImageClassifyMapper infoImageClassifyMapper) {
        this.infoImageClassifyMapper = infoImageClassifyMapper;
    }

    @Override
    public List<InfoImageClassifyVo> selectByParentId(Long classifyId) {
        return this.infoImageClassifyMapper.selectByParentId(classifyId);
    }

    @Override
    public List<InfoImageClassify> selectAllImageClassifyForImg() {
        return this.infoImageClassifyMapper.selectAllImageClassifyForImg();
    }
}

