/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    public XSSRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return values;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.stripXSS(values[i], parameter);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return this.stripXSS(value, parameter);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return this.stripXSS(value, name);
    }

    private String stripXSS(String value, String parameter) {
        String valueNew = value;
        if ("keyWords".equals(parameter)) {
            System.out.println("==========================");
        }
        if (this.getNoCheckParameter(parameter) && valueNew != null) {
            valueNew = valueNew.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            valueNew = scriptPattern.matcher(valueNew).replaceAll("");
            scriptPattern = Pattern.compile("[%<>]+");
            valueNew = scriptPattern.matcher(valueNew).replaceAll("");
        }
        return valueNew;
    }

    private boolean getNoCheckParameter(String parameter) {
        String[] noFilterURLs;
        for (String parameters : noFilterURLs = new String[]{"goodsDetailDesc", "goodsMobileDesc", "bsetUseragreement", "mobileDesc", "bsetUseragreementuser", "bsetCopyright", "content", "thirdUserment", "helpContent", "marketingDes", "giftDesc", "ipCont", "str", "pageDes", "title", "thirdProjectContext", "backInfoRemark", "backPriceRemark", "payHelp", "giftText", "Referer", "brandName"}) {
            if (!parameter.equals(parameters)) continue;
            return false;
        }
        return true;
    }
}

