/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.license.util.checkLicense;

import com.qianjiang.license.bean.MultiFile;
import com.qianjiang.license.util.checkLicense.LicenseUtil;
import com.qianjiang.license.util.checkLicense.RSADeCoder;
import com.qianjiang.license.util.checkLicense.RSAEnCoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class MyRSAEnCoderTools {
    public static final String licenseFilePath = "D:\\license";
    public static final String licenseSourceFileName = "ZZFWServer.txt";
    public static final String licenseFileName = "ZZFWServer.lic";
    public static final String PARAMETERMACHINDECODE = "DKDH8273DJJH839DKKSAYUWCBNXM283";
    public static final String[] defaultFileContent = new String[]{"LICENSEID=BAIDU-FOR-XZXY", "LICENSENAME=xxx\u7cfb\u7edf\u6388\u6743\u7ed9XX\u5927\u5b66", "LICENSETYPE=1", "EXPIREDAY=2017-09-30", "PRINTCLIENTCOUNT=100", "MACHINECODE=DKDH8273DJJH839DKK,SAYUWCBNXM283", "ip=127.0.0.1"};

    public static void initLicensePath() {
        System.out.println("-----------\u5f00\u59cb\u521d\u59cb\u5316\u8def\u5f84-----------");
        try {
            MyRSAEnCoderTools.initLicensePath(licenseFilePath, licenseSourceFileName, defaultFileContent);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("-----------\u521d\u59cb\u5316\u8def\u5f84\u5b8c\u6210-----------");
    }

    public static void genLicenseFile() {
        System.out.println("-----------\u5f00\u59cb\u751f\u6210\u8bc1\u4e66-----------");
        String filePath = licenseFilePath + File.separator + licenseFileName;
        try {
            MyRSAEnCoderTools.genLicenseFile(licenseFilePath, licenseSourceFileName, licenseFileName, defaultFileContent);
            boolean f = false;
            System.out.println("\u8bc1\u4e66check\u7ed3\u679c:" + f);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("-----------\u751f\u6210\u8bc1\u4e66\u5b8c\u6210-----------");
    }

    private static void initLicensePath(String licensePath, String sourceFileName, String[] defaultLicenseContent) throws Exception {
        File file = new File(licensePath + File.separator + sourceFileName);
        File filePath = new File(licensePath);
        if (filePath.exists()) {
            System.out.println("\u8def\u5f84\u5df2\u7ecf\u5b58\u5728:" + filePath.getAbsolutePath());
        } else {
            filePath.mkdirs();
        }
        if (file.exists()) {
            System.out.println("License\u6e90\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728:" + file.getAbsolutePath());
        } else {
            ArrayList<String> lines = new ArrayList<String>();
            int len = defaultLicenseContent.length;
            for (int j = 0; j < len; ++j) {
                if (!StringUtils.isNotEmpty((String)defaultLicenseContent[j])) continue;
                lines.add(defaultLicenseContent[j]);
            }
            FileUtils.writeLines((File)file, (String)"UTF-8", lines);
            System.out.println("\u521d\u59cb\u5316\u8def\u5f84\u5b8c\u6210:" + file.getAbsolutePath());
        }
    }

    private static void genLicenseFile(String licensePath, String sourceFileName, String licenseFileName, String[] defaultLicenseContent) throws Exception {
        FileInputStream fis;
        PrivateKey privateKey = RSAEnCoder.getPrivateKey("168471656040682369067024842962822083298669539093986092465366127155720426564118469603013433851342957534348138682751573582625566160744115198034661810651722103097169587486100008061472372333707837160018287515262612680876274406409425481997533147443089198863298280210902750052071080616127252265650629071271842635449", "150901371025529646290988179678709460820582255579217413062879326125625226668399261526101203807643534082751795733019254351698826384607184496620698500219378204253214947180327085393185504812856350810804446056695865412260029797508072007855612286308169717837624067781580510271891701740762168471560451778085144503393");
        File file = new File(licensePath + File.separator + sourceFileName);
        File licenseFile = new File(licensePath + File.separator + licenseFileName);
        File filePath = new File(licensePath);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if (!file.exists()) {
            MyRSAEnCoderTools.initLicensePath(licensePath, sourceFileName, defaultLicenseContent);
        }
        if (!file.exists()) {
            throw new Exception("\u6ca1\u6709\u83b7\u53d6License\u52a0\u5bc6\u7684\u6e90\u6587\u4ef6");
        }
        if (licenseFile.exists()) {
            licenseFile.delete();
        }
        if ((fis = new FileInputStream(file)).available() == 0) {
            throw new FileNotFoundException("License\u52a0\u5bc6\u7684\u6e90\u6587\u4ef6\u4e3a\u7a7a");
        }
        fis.close();
        byte[] sByte = FileUtils.readFileToByteArray((File)file);
        if (sByte.length == 0) {
            throw new FileNotFoundException("License\u52a0\u5bc6\u7684\u6e90\u6587\u4ef6\u4e3a\u7a7a");
        }
        byte[] encoderData = RSAEnCoder.encryptRSA(sByte, privateKey);
        String sign = RSAEnCoder.sign(encoderData, privateKey);
        byte[] signBytes = ("\n" + sign).getBytes();
        byte[] raw = new byte[encoderData.length + signBytes.length];
        System.arraycopy(encoderData, 0, raw, 0, encoderData.length);
        System.arraycopy(signBytes, 0, raw, encoderData.length, signBytes.length);
        byte[] encoderaw = RSAEnCoder.encryptRSA(raw, privateKey);
        FileUtils.writeByteArrayToFile((File)licenseFile, (byte[])encoderaw);
        System.out.println("License\u751f\u6210\u5b8c\u6210,\u8def\u5f84:" + licenseFile.getAbsolutePath());
    }

    public static Map<String, Object> checkLicenseFile(MultiFile multiFile) throws Exception {
        String sign;
        boolean verify;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String machCode = "";
        Date currentDate = new Date();
        PublicKey publicKey = RSADeCoder.getPublicKey("168471656040682369067024842962822083298669539093986092465366127155720426564118469603013433851342957534348138682751573582625566160744115198034661810651722103097169587486100008061472372333707837160018287515262612680876274406409425481997533147443089198863298280210902750052071080616127252265650629071271842635449", "65537");
        byte[] encoderData = multiFile.getBytes();
        byte[] sbytes = RSADeCoder.decryptRSA(encoderData, publicKey);
        byte[] firstEncoderData = null;
        byte[] secondSignData = null;
        int len = sbytes.length;
        for (int index = 0; index < len; ++index) {
            if (sbytes[index] != 10) continue;
            firstEncoderData = new byte[index];
            secondSignData = new byte[len - index - 1];
            System.arraycopy(sbytes, 0, firstEncoderData, 0, firstEncoderData.length);
            System.arraycopy(sbytes, index + 1, secondSignData, 0, secondSignData.length);
            if (MyRSAEnCoderTools.isArrayByteBase64(secondSignData)) break;
        }
        if (!(verify = RSADeCoder.verify(firstEncoderData, sign = new String(secondSignData), publicKey))) {
            map.put("flag", "5");
            return map;
        }
        byte[] textBytes = RSADeCoder.decryptRSA(firstEncoderData, publicKey);
        System.out.println("\u6388\u6743\u6587\u4ef6\u8be6\u60c5:\n" + new String(textBytes));
        HashMap<String, String> prop = MyRSAEnCoderTools.genDataFromArrayByte(textBytes);
        if (!LicenseUtil.isHasTrueIP(prop.get("LOCALIP"))) {
            map.put("flag", "6");
            return map;
        }
        if (LicenseUtil.isGreaterThanCurrentTime(prop.get("LICENSESTARTTIME"))) {
            map.put("flag", "7");
            return map;
        }
        if (!LicenseUtil.isGreaterThanCurrentTime(prop.get("LICENSEENDTIME"))) {
            map.put("flag", "8");
            return map;
        }
        map.put("flag", "1");
        map.put("prop", prop);
        return map;
    }

    private static HashMap<String, String> genDataFromArrayByte(byte[] b) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(b)));
        HashMap<String, String> data = new HashMap<String, String>();
        String str = null;
        while ((str = br.readLine()) != null) {
            int pos;
            if (!StringUtils.isNotEmpty((String)str) || (pos = (str = str.trim()).indexOf("=")) <= 0) continue;
            if (str.length() > pos + 1) {
                data.put(str.substring(0, pos).trim().toUpperCase(), str.substring(pos + 1).trim());
                continue;
            }
            data.put(str.substring(0, pos).trim().toUpperCase(), "");
        }
        return data;
    }

    private static boolean isArrayByteBase64(byte[] b) {
        try {
            return Base64.isArrayByteBase64((byte[])b);
        }
        catch (Exception e) {
            return false;
        }
    }
}

