/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.District;
import com.qianjiang.system.dao.DistrictMapper;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.system.vo.DistrictVo;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="DistrictService")
public class DistrictServiceImpl
implements DistrictService {
    private DistrictMapper districtMapper;

    public DistrictMapper getDistrictMapper() {
        return this.districtMapper;
    }

    @Resource(name="DistrictMapper")
    public void setDistrictMapper(DistrictMapper districtMapper) {
        this.districtMapper = districtMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveDistrict(String districtName, String cityId, String districtSort) {
        District district = new District();
        try {
            if (null != districtName) {
                district.setDistrictName(districtName);
                district.setDistrictSort(districtSort);
                district.setCityId(Long.parseLong(cityId));
                district.setDelFlag("0");
                int n = this.districtMapper.insertSelective(district);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            district = null;
        }
    }

    @Override
    public int delDistrict(Long districtId) {
        return this.districtMapper.deleteByPrimaryKey(districtId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateDistrict(String districtId, String districtName, String districtSort) {
        District district = new District();
        try {
            if (null != districtId) {
                district.setDistrictId(Long.parseLong(districtId));
                district.setDistrictName(districtName);
                district.setDistrictSort(districtSort);
                int n = this.districtMapper.updateByPrimaryKeySelective(district);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            district = null;
        }
    }

    @Override
    public District findDistrictByPrimaryKey(Long districtId) {
        return this.districtMapper.selectByPrimaryKey(districtId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean findListByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            pb.setRows(this.districtMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.districtMapper.queryDistrictListByPb(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public int batchDelDistrict(String[] districtIds) {
        int count = 0;
        if (null != districtIds && districtIds.length > 0) {
            for (int i = 0; i < districtIds.length; ++i) {
                count += this.districtMapper.deleteByPrimaryKey(Long.parseLong(districtIds[i]));
            }
        }
        return count;
    }

    @Override
    public List<DistrictVo> queryDistrictByCityId(Long cityId) {
        return this.districtMapper.queryDistrictListByCityId(cityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkDistrictName(String districtName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("districtName", districtName);
            boolean bl = this.districtMapper.queryDistrictByDistrictName(map) <= 0;
            return bl;
        }
        finally {
            map = null;
        }
    }

    @Override
    public AddressUtil queryAddressNameByDistrictId(Long districtId) {
        return this.districtMapper.queryAddressNameByDistrictId(districtId);
    }

    @Override
    public List<Object> queryDistrictByCityIdAndDistName(Long cityId, String districtName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cityId", cityId);
        paramMap.put("districtName", districtName);
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", 1000);
        return this.districtMapper.queryDistrictListByPb(paramMap);
    }

    @Override
    public int queryDistrictNameCount(District district) {
        return this.districtMapper.queryDistrictNameCount(district);
    }
}

