/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.version.service.impl;

import com.qianjiang.util.PageBean;
import com.qianjiang.util.UtilDate;
import com.qianjiang.version.bean.Version;
import com.qianjiang.version.mapper.VersionMapper;
import com.qianjiang.version.service.VersionService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="versionService")
public class VersionServiceImpl
implements VersionService {
    private VersionMapper versionMapper;

    @Override
    public List<Version> seleceVersion() {
        return this.versionMapper.seleceVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectAllVersion(PageBean pageBean, Version version) {
        HashMap<String, Object> paramMap = null;
        try {
            Long count = this.versionMapper.selectVersionSize(version);
            pageBean.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
            if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
                pageBean.setPageNo(pageBean.getLastPageNo());
            }
            if (pageBean.getPageNo() == 0) {
                pageBean.setPageNo(1);
            }
            paramMap = new HashMap<String, Object>();
            paramMap.put("version", version);
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.versionMapper.selectAllVersion(paramMap));
        }
        finally {
            paramMap = null;
        }
        return pageBean;
    }

    @Override
    public int addVersion(Version version, String date) {
        version.setVersionTime(UtilDate.stringToDate(date));
        return this.versionMapper.insertSelective(version);
    }

    @Override
    public int updateVersion(Version version, String date) {
        version.setVersionTime(UtilDate.stringToDate(date));
        return this.versionMapper.updateByPrimaryKeySelective(version);
    }

    @Override
    public Version showVersion(Long versionId) {
        return this.versionMapper.selectByPrimaryKey(versionId);
    }

    @Override
    public Version showNewVersion() {
        return this.versionMapper.showNewVersion();
    }

    public VersionMapper getVersionMapper() {
        return this.versionMapper;
    }

    @Resource(name="versionMapper")
    public void setVersionMapper(VersionMapper versionMapper) {
        this.versionMapper = versionMapper;
    }
}

