/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.service.impl;

import com.qianjiang.channel.bean.ChannelBar;
import com.qianjiang.channel.dao.ChannelBarMapper;
import com.qianjiang.channel.service.ChannelBarService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ChannelBarService")
public class ChannelBarServiceImpl
implements ChannelBarService {
    private static final MyLogger LOGGER = new MyLogger(ChannelBarServiceImpl.class);
    @Resource(name="ChannelBarMapper")
    private ChannelBarMapper channelBarMapper;

    @Override
    public int deleteChannelBar(Long barId) {
        ChannelBar cb = this.channelBarMapper.selectByPrimaryKey(barId);
        cb.setDeleteStatus(1);
        cb.setModifyDate(new Date());
        return this.channelBarMapper.updateByPrimaryKeySelective(cb);
    }

    @Override
    public int saveChannelBar(ChannelBar record) {
        Date date = new Date();
        record.setDeleteStatus(0);
        record.setInsertDate(date);
        record.setModifyDate(date);
        return this.channelBarMapper.insertSelective(record);
    }

    @Override
    public int updateChannelBar(ChannelBar record) {
        record.setModifyDate(new Date());
        return this.channelBarMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public ChannelBar getChannelBarById(Long barId) {
        return this.channelBarMapper.selectByPrimaryKey(barId);
    }

    @Override
    public PageBean selectChannelBarByParam(PageBean pb, Long channelId, Long tempId, String third) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("channelId", channelId);
            map.put("tempId", tempId);
            map.put("expFleid1", third);
            pb.setRows(this.channelBarMapper.selectChannelBarCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.channelBarMapper.selectChannelBarByParam(map));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5206\u9875\u53c2\u6570\u548c\u9891\u9053ID\u3001\u6a21\u677fID\u67e5\u8be2\u9891\u9053\u5bfc\u822a\u5931\u8d25" + e.getMessage(), e);
        }
        return pb;
    }

    @Override
    public List<ChannelBar> selectAllChannelBarByParam(Long channelId, Long tempId, String third) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelId", channelId);
        map.put("tempId", tempId);
        map.put("expFleid1", third);
        return this.channelBarMapper.selectAllChannelBarByParam(map);
    }
}

