/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.dao.ChannelAdverMapper;
import com.qianjiang.channel.dao.ChannelStoreyMapper;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ChannelStoreyService")
public class ChannelStoreyServiceImpl
implements ChannelStoreyService {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyServiceImpl.class);
    private static final String LOGINUSERID = "loginUserId";
    @Resource(name="ChannelStoreyMapper")
    private ChannelStoreyMapper channelStoreyMapper;
    @Resource(name="ChannelAdverMapper")
    private ChannelAdverMapper channelAdverMapper;

    @Override
    public int deleteChannelStorey(Long channelStoreyId, Long userId) {
        ChannelStorey channelStorey = this.channelStoreyMapper.selectByPrimaryKey(channelStoreyId);
        channelStorey.setDelflag("1");
        channelStorey.setUpdateUserId(userId);
        channelStorey.setUpdateDate(new Date());
        return this.channelStoreyMapper.updateByPrimaryKeySelective(channelStorey);
    }

    @Override
    public int saveChannelStorey(ChannelStorey record) {
        Date date = new Date();
        record.setDelflag("0");
        record.setCreateDate(date);
        record.setUpdateDate(date);
        return this.channelStoreyMapper.insertSelective(record);
    }

    @Override
    public int updateChannelStorey(ChannelStorey record) {
        record.setUpdateDate(new Date());
        return this.channelStoreyMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public ChannelStorey getChannelStoreyById(Long channelStoreyId) {
        return this.channelStoreyMapper.selectByPrimaryKey(channelStoreyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectchannelStoreyByParam(PageBean pb, Long channelId, Long tempId, String temp1) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("channelId", channelId);
            map.put("tempId", tempId);
            map.put("temp1", temp1);
            pb.setRows(this.channelStoreyMapper.selectchannelStoreyCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            List<Object> channelStoreyList = this.channelStoreyMapper.selectchannelStoreyByParam(map);
            if (channelStoreyList != null && !channelStoreyList.isEmpty()) {
                for (Object obj : channelStoreyList) {
                    if (obj == null || !(obj instanceof ChannelStorey)) continue;
                    ChannelStorey channelStorey = (ChannelStorey)obj;
                    Long channelStoreyId = channelStorey.getChannelStoreyId();
                    Integer floorStyle = channelStorey.getFloorId();
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("floorId", channelStoreyId);
                    paramMap.put("floorStyle", floorStyle);
                    paramMap.put("adverFlag", 1);
                    List<ChannelAdver> generalAdver = this.channelAdverMapper.queryByParam(paramMap);
                    channelStorey.setGeneralAdvers(generalAdver);
                    paramMap.put("adverFlag", 2);
                    List<ChannelAdver> rotationAdver = this.channelAdverMapper.queryByParam(paramMap);
                    channelStorey.setRotationAdvers(rotationAdver);
                    paramMap.put("adverFlag", 3);
                    List<ChannelAdver> tagAdver = this.channelAdverMapper.queryByParam(paramMap);
                    channelStorey.setTagAdvers(tagAdver);
                }
            }
            pb.setList(channelStoreyList);
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public List<ChannelStorey> selectchannelStoreyByParamForSite(Long channelId, Long tempId, String temp1) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelId", channelId);
        map.put("tempId", tempId);
        map.put("temp1", temp1);
        return this.channelStoreyMapper.selectchannelStoreyByParamForSite(map);
    }

    @Override
    public int deleteByPrimaryKeyCallPro(Long channelStoreyId) {
        return this.channelStoreyMapper.deleteByPrimaryKeyCallPro(channelStoreyId);
    }

    @Override
    public Map<String, Object> queryTempStore(Long storeyId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            ChannelStorey channelStorey = this.channelStoreyMapper.selectByPrimaryKey(storeyId);
            if (channelStorey != null) {
                Integer floorStyle = channelStorey.getFloorId();
                if (floorStyle != null) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("floorId", storeyId);
                    paramMap.put("floorStyle", floorStyle);
                    paramMap.put("adverFlag", 1);
                    List<ChannelAdver> generalAdver = this.channelAdverMapper.queryByParam(paramMap);
                    paramMap.put("adverFlag", 2);
                    List<ChannelAdver> rotationAdver = this.channelAdverMapper.queryByParam(paramMap);
                    paramMap.put("adverFlag", 3);
                    List<ChannelAdver> tagAdver = this.channelAdverMapper.queryByParam(paramMap);
                    resultMap.put("generalAdver", generalAdver);
                    resultMap.put("rotationAdver", rotationAdver);
                    resultMap.put("tagAdver", tagAdver);
                }
                resultMap.put("channelStorey", channelStorey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u697c\u5c42\u6a21\u677f\u4fe1\u606f\u5931\u8d25" + e.getMessage(), e);
        }
        return resultMap;
    }

    @Override
    public int operateTempStoreyAjax(Long loginUserId, Map<String, Object> obj) {
        int result = 0;
        Date currentDate = new Date();
        String data = JSON.toJSONString(obj);
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            JSONObject json = JSON.parseObject((String)data);
            JSONArray modifyTempStoreArray = json.getJSONArray("modifyTempStoreArr");
            LOGGER.info("modifyTempStoreArray:" + modifyTempStoreArray);
            LOGGER.info("modifyTempStoreArray size:" + modifyTempStoreArray.size());
            JSONArray modifyChannelAdverArray = json.getJSONArray("modifyChannelAdverArr");
            LOGGER.info("modifyChannelAdverArray:" + modifyChannelAdverArray);
            LOGGER.info("modifyChannelAdverArray size:" + modifyChannelAdverArray.size());
            JSONArray modifyChannelRotationArray = json.getJSONArray("modifyChannelRotationArr");
            LOGGER.info("modifyChannelRotationArray:" + modifyChannelRotationArray);
            LOGGER.info("modifyChannelRotationArray size:" + modifyChannelRotationArray.size());
            JSONArray modifyChannelTagArray = json.getJSONArray("modifyChannelTagArr");
            LOGGER.info("modifyChannelTagArray:" + modifyChannelTagArray);
            LOGGER.info("modifyChannelTagArray size:" + modifyChannelTagArray.size());
            if (modifyTempStoreArray.size() > 0) {
                Long channelStoreyId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyTempStoreArray.get(0))).getLong("channelStoreyId");
                String storeyName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyTempStoreArray.get(0))).getString("storeyName");
                Long goodsCatId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyTempStoreArray.get(0))).getLong("goodsCatId");
                String storeyImg = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyTempStoreArray.get(0))).getString("storeyImg");
                String storeyImgHref = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyTempStoreArray.get(0))).getString("storeyImgHref");
                Integer floorId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyTempStoreArray.get(0))).getInteger("floorId");
                int deleteResult = this.channelAdverMapper.delByFloorId(channelStoreyId);
                LOGGER.info("delete result:" + deleteResult);
                ChannelStorey channelStorey = new ChannelStorey();
                channelStorey.setStoreyName(storeyName);
                channelStorey.setGoodsCatId(goodsCatId);
                channelStorey.setStoreyImg(storeyImg);
                channelStorey.setStoreyImgHref(storeyImgHref);
                channelStorey.setFloorId(floorId);
                channelStorey.setUpdateDate(currentDate);
                channelStorey.setUpdateUserId(loginUserId);
                channelStorey.setChannelStoreyId(channelStoreyId);
                this.channelStoreyMapper.updateByPrimaryKeySelective(channelStorey);
                if (modifyChannelAdverArray.size() > 0) {
                    this.editChannelAdver(loginUserId, modifyChannelAdverArray);
                }
                if (modifyChannelRotationArray.size() > 0) {
                    this.editChannelAdver(loginUserId, modifyChannelRotationArray);
                }
                if (modifyChannelTagArray.size() > 0) {
                    this.editChannelAdver(loginUserId, modifyChannelTagArray);
                }
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u6a21\u677f\u697c\u5c42\u64cd\u4f5c\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }

    private void editChannelAdver(Long loginUserId, JSONArray channelAdverArray) {
        Date currentDate = new Date();
        try {
            for (int i = 0; i < channelAdverArray.size(); ++i) {
                String adverName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getString("adverName");
                String adverPath = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getString("adverPath");
                String adverHref = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getString("adverHref");
                Integer adverSort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getInteger("adverSort");
                Integer adverFlag = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getInteger("adverFlag");
                Long floorId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getLong("floorId");
                Long atId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getLong("atId");
                Long adverType = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getLong("adverType");
                String temp3 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getString("temp3");
                String temp5 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getString("temp5");
                Long channelAdverId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)channelAdverArray.get(i))).getLong("channelAdverId");
                ChannelAdver channelAdver = new ChannelAdver();
                channelAdver.setAdverName(adverName);
                channelAdver.setAdverPath(adverPath);
                channelAdver.setAdverHref(adverHref);
                channelAdver.setAdverSort(adverSort);
                channelAdver.setAdverFlag(adverFlag);
                channelAdver.setFloorId(floorId);
                channelAdver.setAtId(atId);
                channelAdver.setAdverType(adverType);
                channelAdver.setTemp3(temp3);
                channelAdver.setTemp5(temp5);
                channelAdver.setUserStatus("1");
                channelAdver.setDelflag("0");
                channelAdver.setCreateDate(currentDate);
                channelAdver.setUpdateDate(currentDate);
                channelAdver.setCreateUserId(loginUserId);
                channelAdver.setUpdateUserId(loginUserId);
                this.channelAdverMapper.insertSelective(channelAdver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6a21\u677f\u5e7f\u544a\u516c\u5171\u65b9\u6cd5\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public int deleteTempStorey(Long loginUserId, Long storeyId) {
        int result = 0;
        Date currentDate = new Date();
        try {
            ChannelStorey channelStorey = new ChannelStorey();
            channelStorey.setDelflag("1");
            channelStorey.setUpdateUserId(loginUserId);
            channelStorey.setUpdateDate(currentDate);
            channelStorey.setChannelStoreyId(storeyId);
            this.channelStoreyMapper.updateByPrimaryKeySelective(channelStorey);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("delflag", "1");
            paramMap.put("updateUserId", loginUserId);
            paramMap.put("updateDate", currentDate);
            paramMap.put("floorId", storeyId);
            this.channelAdverMapper.updateByFloorId(paramMap);
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5220\u9664\u697c\u5c42\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }
}

