/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.service.impl;

import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.dao.ChannelTrademarkMapper;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ChannelTrademarkService")
public class ChannelTrademarkServiceImpl
implements ChannelTrademarkService {
    private static final MyLogger LOGGER = new MyLogger(ChannelTrademarkServiceImpl.class);
    private static final String CHANNELID = "channelId";
    private static final String TEMPID = "tempId";
    private static final String TEMP1 = "temp1";
    private static final String TEMP2 = "temp2";
    private ChannelTrademarkMapper channelTrademarkMapper;

    @Override
    public int deleteChannelTrademark(Long channelTrademarkId, Long userId) {
        try {
            ChannelTrademark channelTrademark = this.channelTrademarkMapper.selectByPrimaryKey(channelTrademarkId);
            channelTrademark.setDelflag("1");
            channelTrademark.setUpdateUserId(userId);
            channelTrademark.setUpdateDate(new Date());
            return this.channelTrademarkMapper.updateByPrimaryKeySelective(channelTrademark);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u9891\u9053\u5e7f\u544a\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int saveChannelTrademark(ChannelTrademark record) {
        try {
            Date date = new Date();
            record.setCreateDate(date);
            record.setUpdateDate(date);
            record.setDelflag("0");
            return this.channelTrademarkMapper.insertSelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u9891\u9053\u5e7f\u544a\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int updateChannelTrademark(ChannelTrademark record) {
        try {
            record.setUpdateDate(new Date());
            return this.channelTrademarkMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u5e7f\u544a\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public ChannelTrademark getChannelTrademarkById(Long channelTrademarkId) {
        ChannelTrademark channelTrademark = null;
        try {
            channelTrademark = this.channelTrademarkMapper.selectByPrimaryKey(channelTrademarkId);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636eID\u67e5\u8be2\u9891\u9053\u54c1\u724c\u9519\u8bef:", e);
        }
        return channelTrademark;
    }

    @Override
    public PageBean selectchannelTrademarkByParam(PageBean pb, Long channelId, Long tempId, Long storeyId, Long storeyTagId, String temp1, String temp3) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CHANNELID, channelId);
            map.put(TEMPID, tempId);
            map.put("storeyId", storeyId);
            map.put("storeyTagId", storeyTagId);
            map.put(TEMP1, temp1);
            map.put(TEMP2, "0");
            map.put("temp3", temp3);
            pb.setRows(this.channelTrademarkMapper.selectchannelTrademarkCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.channelTrademarkMapper.selectchannelTrademarkByParam(map));
            return pb;
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u54c1\u724c\u5217\u8868\u9519\u8bef:", e);
            return null;
        }
    }

    @Override
    public PageBean selectClassifyTrademarkByParam(PageBean pb, Long tempId, Long channelId, String temp1, String temp2) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TEMP1, temp1);
            map.put(TEMP2, temp2);
            map.put(TEMPID, tempId);
            map.put(CHANNELID, channelId);
            pb.setRows(this.channelTrademarkMapper.selectchannelTrademarkCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.channelTrademarkMapper.selectchannelTrademarkByParam(map));
            return pb;
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u5206\u7c7b\u5bfc\u822a\u54c1\u724c\u5217\u8868\u9519\u8bef:", e);
            return null;
        }
    }

    @Override
    public List<ChannelTrademark> selectChannelTrademarkByParamForSite(Long channelId, Long tempId, Long storeyId, Long storeyTagId, String temp1, String temp2, String temp3) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CHANNELID, channelId);
            map.put(TEMPID, tempId);
            map.put("storeyId", storeyId);
            map.put("storeyTagId", storeyTagId);
            map.put(TEMP1, temp1);
            map.put(TEMP2, temp2);
            map.put("temp3", temp3);
            return this.channelTrademarkMapper.selectChannelTrademarkByParamForSite(map);
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u54c1\u724c\u5217\u8868\u9519\u8bef:", e);
            return Collections.emptyList();
        }
    }

    public ChannelTrademarkMapper getChannelTrademarkMapper() {
        return this.channelTrademarkMapper;
    }

    @Resource(name="ChannelTrademarkMapper")
    public void setChannelTrademarkMapper(ChannelTrademarkMapper channelTrademarkMapper) {
        this.channelTrademarkMapper = channelTrademarkMapper;
    }

    @Override
    public List<ChannelTrademark> selectTrademarkByTempId(Long tempId) {
        return this.channelTrademarkMapper.selectTrademarkByTempId(tempId);
    }
}

