/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core;

import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.cfg.Configuration;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.cfg.DefaultConfig;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.AnalyzeContext;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.CJKSegmenter;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.CNQuantifierSegmenter;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.IKArbitrator;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.ISegmenter;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.LetterSegmenter;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.Lexeme;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic.Dictionary;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public final class IKSegmenter {
    private Reader input;
    private Configuration cfg;
    private AnalyzeContext context;
    private List<ISegmenter> segmenters;
    private IKArbitrator arbitrator;

    public IKSegmenter(Reader input, boolean useSmart) {
        this.input = input;
        this.cfg = DefaultConfig.getInstance();
        this.cfg.setUseSmart(useSmart);
        this.init();
    }

    public IKSegmenter(Reader input, Configuration cfg) {
        this.input = input;
        this.cfg = cfg;
        this.init();
    }

    private void init() {
        Dictionary.initial(this.cfg);
        this.context = new AnalyzeContext(this.cfg);
        this.segmenters = this.loadSegmenters();
        this.arbitrator = new IKArbitrator();
    }

    private List<ISegmenter> loadSegmenters() {
        ArrayList<ISegmenter> segmenters = new ArrayList<ISegmenter>(4);
        segmenters.add(new LetterSegmenter());
        segmenters.add(new CNQuantifierSegmenter());
        segmenters.add(new CJKSegmenter());
        return segmenters;
    }

    public synchronized Lexeme next() throws IOException {
        Lexeme l = null;
        while ((l = this.context.getNextLexeme()) == null) {
            int available = this.context.fillBuffer(this.input);
            if (available <= 0) {
                this.context.reset();
                return null;
            }
            this.context.initCursor();
            do {
                for (ISegmenter segmenter : this.segmenters) {
                    segmenter.analyze(this.context);
                }
            } while (!this.context.needRefillBuffer() && this.context.moveCursor());
            for (ISegmenter segmenter : this.segmenters) {
                segmenter.reset();
            }
            this.arbitrator.process(this.context, this.cfg.useSmart());
            this.context.outputToResult();
            this.context.markBufferOffset();
        }
        return l;
    }

    public synchronized void reset(Reader input) {
        this.input = input;
        this.context.reset();
        for (ISegmenter segmenter : this.segmenters) {
            segmenter.reset();
        }
    }
}

