/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core;

import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.Lexeme;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.QuickSortSet;

class LexemePath
extends QuickSortSet
implements Comparable<LexemePath> {
    private int pathBegin = -1;
    private int pathEnd = -1;
    private int payloadLength = 0;

    LexemePath() {
    }

    boolean addCrossLexeme(Lexeme lexeme) {
        if (this.isEmpty()) {
            this.addLexeme(lexeme);
            this.pathBegin = lexeme.getBegin();
            this.pathEnd = lexeme.getBegin() + lexeme.getLength();
            this.payloadLength += lexeme.getLength();
            return true;
        }
        if (this.checkCross(lexeme)) {
            this.addLexeme(lexeme);
            if (lexeme.getBegin() + lexeme.getLength() > this.pathEnd) {
                this.pathEnd = lexeme.getBegin() + lexeme.getLength();
            }
            this.payloadLength = this.pathEnd - this.pathBegin;
            return true;
        }
        return false;
    }

    boolean addNotCrossLexeme(Lexeme lexeme) {
        if (this.isEmpty()) {
            this.addLexeme(lexeme);
            this.pathBegin = lexeme.getBegin();
            this.pathEnd = lexeme.getBegin() + lexeme.getLength();
            this.payloadLength += lexeme.getLength();
            return true;
        }
        if (this.checkCross(lexeme)) {
            return false;
        }
        this.addLexeme(lexeme);
        this.payloadLength += lexeme.getLength();
        Lexeme head = this.peekFirst();
        this.pathBegin = head.getBegin();
        Lexeme tail = this.peekLast();
        this.pathEnd = tail.getBegin() + tail.getLength();
        return true;
    }

    Lexeme removeTail() {
        Lexeme tail = this.pollLast();
        if (this.isEmpty()) {
            this.pathBegin = -1;
            this.pathEnd = -1;
            this.payloadLength = 0;
        } else {
            this.payloadLength -= tail.getLength();
            Lexeme newTail = this.peekLast();
            this.pathEnd = newTail.getBegin() + newTail.getLength();
        }
        return tail;
    }

    boolean checkCross(Lexeme lexeme) {
        return lexeme.getBegin() >= this.pathBegin && lexeme.getBegin() < this.pathEnd || this.pathBegin >= lexeme.getBegin() && this.pathBegin < lexeme.getBegin() + lexeme.getLength();
    }

    int getPathBegin() {
        return this.pathBegin;
    }

    int getPathEnd() {
        return this.pathEnd;
    }

    int getPayloadLength() {
        return this.payloadLength;
    }

    int getPathLength() {
        return this.pathEnd - this.pathBegin;
    }

    int getXWeight() {
        int product = 1;
        for (QuickSortSet.Cell c = this.getHead(); c != null && c.getLexeme() != null; c = c.getNext()) {
            product *= c.getLexeme().getLength();
        }
        return product;
    }

    int getPWeight() {
        int pWeight = 0;
        int p = 0;
        for (QuickSortSet.Cell c = this.getHead(); c != null && c.getLexeme() != null; c = c.getNext()) {
            pWeight += ++p * c.getLexeme().getLength();
        }
        return pWeight;
    }

    LexemePath copy() {
        LexemePath theCopy = new LexemePath();
        theCopy.pathBegin = this.pathBegin;
        theCopy.pathEnd = this.pathEnd;
        theCopy.payloadLength = this.payloadLength;
        for (QuickSortSet.Cell c = this.getHead(); c != null && c.getLexeme() != null; c = c.getNext()) {
            theCopy.addLexeme(c.getLexeme());
        }
        return theCopy;
    }

    @Override
    public int compareTo(LexemePath o) {
        if (this.payloadLength > o.payloadLength) {
            return -1;
        }
        if (this.payloadLength < o.payloadLength) {
            return 1;
        }
        if (this.size() < o.size()) {
            return -1;
        }
        if (this.size() > o.size()) {
            return 1;
        }
        if (this.getPathLength() > o.getPathLength()) {
            return -1;
        }
        if (this.getPathLength() < o.getPathLength()) {
            return 1;
        }
        if (this.pathEnd > o.pathEnd) {
            return -1;
        }
        if (this.pathEnd < o.pathEnd) {
            return 1;
        }
        if (this.getXWeight() > o.getXWeight()) {
            return -1;
        }
        if (this.getXWeight() < o.getXWeight()) {
            return 1;
        }
        if (this.getPWeight() > o.getPWeight()) {
            return -1;
        }
        if (this.getPWeight() < o.getPWeight()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("pathBegin  : ").append(this.pathBegin).append("\r\n");
        sb.append("pathEnd  : ").append(this.pathEnd).append("\r\n");
        sb.append("payloadLength  : ").append(this.payloadLength).append("\r\n");
        for (QuickSortSet.Cell head = this.getHead(); head != null; head = head.getNext()) {
            sb.append("lexeme : ").append(head.getLexeme()).append("\r\n");
        }
        return sb.toString();
    }
}

