/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util.alipay.util;

import com.qianjiang.common.util.alipay.config.AlipayConfig;
import com.qianjiang.common.util.alipay.sign.MD5;
import com.qianjiang.common.util.alipay.util.AlipayCore;
import com.qianjiang.util.MyLogger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class AlipayNotify {
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";
    public static final MyLogger LOGGER = new MyLogger(AlipayNotify.class);

    private AlipayNotify() {
    }

    public static boolean verify(Map<String, String> params) {
        String responseTxt = "true";
        if (params.get("notify_id") != null) {
            String notifyId = params.get("notify_id");
            responseTxt = AlipayNotify.verifyResponse(notifyId);
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        boolean isSign = AlipayNotify.getSignVeryfy(params, sign);
        String sWord = "responseTxt=" + responseTxt + "\n isSign=" + isSign + "\n \u8fd4\u56de\u56de\u6765\u7684\u53c2\u6570\uff1a" + AlipayCore.createLinkString(params);
        AlipayCore.logResult(sWord);
        LOGGER.info("===" + sWord);
        boolean okOrCan = false;
        if (isSign && "true".equals(responseTxt)) {
            okOrCan = true;
        }
        return okOrCan;
    }

    private static boolean getSignVeryfy(Map<String, String> params, String sign) {
        Map<String, String> sParaNew = AlipayCore.paraFilter(params);
        String preSignStr = AlipayCore.createLinkString(sParaNew);
        boolean isSign = false;
        if ("MD5".equals(AlipayConfig.sign_type)) {
            isSign = MD5.verify(preSignStr, sign, AlipayConfig.key, AlipayConfig.input_charset);
        }
        return isSign;
    }

    private static String verifyResponse(String notifyId) {
        String partner = AlipayConfig.partner;
        String veryfyUrl = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notifyId;
        return AlipayNotify.checkUrl(veryfyUrl);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine;
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
            in.close();
        }
        catch (Exception e) {
            LOGGER.error("", e);
            inputLine = "";
        }
        return inputLine;
    }
}

