/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util.wxap;

import com.qianjiang.common.util.wxap.util.MD5Util;
import com.qianjiang.common.util.wxap.util.Sha1Util;
import com.qianjiang.common.util.wxap.util.TenpayUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHandler {
    private String gateUrl;
    private String notifyUrl;
    private String appid;
    private String appkey;
    private String partnerkey;
    private String appsecret;
    private String key;
    private SortedMap parameters;
    private String Token;
    private String charset;
    private String debugInfo;
    private String last_errcode = "0";
    private HttpServletRequest request;
    private HttpServletResponse response;

    public RequestHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.charset = "GBK";
        this.parameters = new TreeMap();
        this.notifyUrl = "https://gw.tenpay.com/gateway/simpleverifynotifyid.xml";
    }

    public static String buildRequest(Map<String, String> sParaTemp, String strButtonName) {
        ArrayList<String> keys = new ArrayList<String>(sParaTemp.keySet());
        StringBuilder sbHtml = new StringBuilder();
        sbHtml.append(" <script language='javascript'>");
        sbHtml.append("document.addEventListener('WeixinJSBridgeReady', function onBridgeReady() {");
        sbHtml.append("WeixinJSBridge.invoke('getBrandWCPayRequest',{");
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sParaTemp.get(name);
            if ("appkey".equals(name)) continue;
            sbHtml.append("'" + name + "'" + ":" + "'" + value + "'");
            if (i >= keys.size() - 1) continue;
            sbHtml.append(",");
        }
        sbHtml.append(" },function(res){");
        sbHtml.append("  alert(res.err_msg); if(res.err_msg == 'get_brand_wcpay_request:ok' ) {}");
        sbHtml.append("  });");
        sbHtml.append(" }, false)");
        sbHtml.append("</script>");
        return sbHtml.toString();
    }

    public void init(String appId, String appSecret, String appKey, String partnerKey) {
        this.last_errcode = "0";
        this.Token = "token_";
        this.debugInfo = "";
        this.appkey = appKey;
        this.appid = appId;
        this.partnerkey = partnerKey;
        this.appsecret = appSecret;
    }

    public void init() {
    }

    public String getLasterrCode() {
        return this.last_errcode;
    }

    public String getGateUrl() {
        return this.gateUrl;
    }

    public String getParameter(String parameter) {
        String s = (String)this.parameters.get(parameter);
        return null == s ? "" : s;
    }

    public void setKey(String key) {
        this.partnerkey = key;
    }

    public void setAppKey(String key) {
        this.appkey = key;
    }

    public String UrlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, this.charset).replace("+", "%20");
    }

    public String genPackage(SortedMap<String, String> packageParams) throws UnsupportedEncodingException {
        String sign = this.createSign(packageParams);
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            sb.append(k + "=" + this.UrlEncode(v) + "&");
        }
        return sb.append("sign=" + sign).toString();
    }

    public String createSign(SortedMap<String, String> packageParams) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + this.partnerkey);
        return MD5Util.MD5Encode(sb.toString(), this.charset).toUpperCase();
    }

    public String createSign2(SortedMap<String, String> packageParams) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + this.partnerkey);
        return Sha1Util.getSha1(sb.toString());
    }

    public boolean createMd5Sign(String signParams) {
        StringBuilder sb = new StringBuilder();
        Set es = this.parameters.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if ("sign".equals(k) || null == v || "".equals(v)) continue;
            sb.append(k + "=" + v + "&");
        }
        String enc = TenpayUtil.getCharacterEncoding(this.request, this.response);
        String sign = MD5Util.MD5Encode(sb.toString(), enc).toLowerCase();
        String tenpaySign = this.getParameter("sign").toLowerCase();
        this.setDebugInfo(sb.toString() + " => sign:" + sign + " tenpaySign:" + tenpaySign);
        return tenpaySign.equals(sign);
    }

    public String parseXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        Set es = this.parameters.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (null == v || "".equals(v) || "appkey".equals(k)) continue;
            sb.append("<" + k + ">" + this.getParameter(k) + "</" + k + ">\n");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    protected void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public void setPartnerkey(String partnerkey) {
        this.partnerkey = partnerkey;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public String getKey() {
        return this.key;
    }
}

