/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.hotsearch.service.impl;

import com.qianjiang.hotsearch.bean.HotSearch;
import com.qianjiang.hotsearch.dao.HotSearchMapper;
import com.qianjiang.hotsearch.service.HotSearchService;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="hotSearchService")
public class HotSearchServiceImpl
implements HotSearchService {
    @Resource
    private HotSearchMapper hotSearchMapper;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public int removeHotSearchById(Long hotSearchId) {
        HotSearch hotSearch = this.hotSearchMapper.selectByPrimaryKey(hotSearchId);
        hotSearch.setDelFlag("1");
        this.redisAdapter.delete("HOTSEARCH_KEY");
        return this.hotSearchMapper.updateByPrimaryKeySelective(hotSearch);
    }

    @Override
    public int addHotSearchSelective(HotSearch hotSearch) {
        hotSearch.setUpdateDate(new Date());
        this.redisAdapter.delete("HOTSEARCH_KEY");
        return this.hotSearchMapper.insertSelective(hotSearch);
    }

    @Override
    public HotSearch selectHotSearchById(Long hotSearchId) {
        return this.hotSearchMapper.selectByPrimaryKey(hotSearchId);
    }

    @Override
    public int modifyHostSearchSelectiveById(HotSearch hotSearch) {
        hotSearch.setUpdateDate(new Date());
        this.redisAdapter.delete("HOTSEARCH_KEY");
        return this.hotSearchMapper.updateByPrimaryKeySelective(hotSearch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryHotBySelectivePageSize(String keyword, Long tempid, Long channelid, PageBean pageBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("keyword", keyword);
            map.put("tempid", tempid);
            map.put("channelid", channelid);
            pageBean.setRows(this.hotSearchMapper.selectHotSearchCount(map));
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.hotSearchMapper.selectHotBySelectivePageSize(map));
        }
        finally {
            map = null;
        }
        return pageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int batchDelHotSearch(Long[] hots) {
        int count = 0;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            if (hots != null && hots.length >= 0) {
                for (int i = 0; i < hots.length; ++i) {
                    Long id = hots[i];
                    list.add(id);
                }
                count = this.hotSearchMapper.batchDelHotSearch(list);
            }
        }
        finally {
            list = null;
        }
        this.redisAdapter.delete("HOTSEARCH_KEY");
        return count;
    }

    @Override
    public List<HotSearch> selectHotBySelectiveForSite(Long tempid, Long channelid) {
        List<HotSearch> hotSearchs = (List<HotSearch>)this.redisAdapter.get("HOTSEARCH_KEY");
        if (!CollectionUtils.isEmpty((Collection)hotSearchs)) {
            return hotSearchs;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tempid", tempid);
        map.put("channelid", channelid);
        hotSearchs = this.hotSearchMapper.selectHotBySelectiveForSite(map);
        this.redisAdapter.put("HOTSEARCH_KEY", new ArrayList<HotSearch>(hotSearchs));
        return hotSearchs;
    }
}

