/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.image.service.impl;

import com.qianjiang.image.bean.InfoImageManage;
import com.qianjiang.image.dao.InfoImageManageMapper;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="InfoImageManageService")
public class InfoImageManageServiceImpl
implements InfoImageManageService {
    private static final MyLogger LOGGER = new MyLogger(InfoImageManageServiceImpl.class);
    private static final String CLASSIFYID = "classifyId";
    private static final String THIRDID = "thirdId";
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private static final String LOGGERINFO1 = "\u5206\u9875\u67e5\u8be2\u56fe\u7247\u4fe1\u606f\u5217\u8868\u9519\u8bef:";
    private InfoImageManageMapper ifoImageManageMapper;

    @Override
    public int deleteInfoImageManage(Long imageManageId) {
        try {
            return this.ifoImageManageMapper.deleteByPrimaryKey(imageManageId);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u56fe\u7247\u4fe1\u606f\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int saveInfoImageManage(InfoImageManage record) {
        try {
            Date date = new Date();
            record.setCreateDate(date);
            record.setUpdateDate(date);
            return this.ifoImageManageMapper.insertSelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u56fe\u7247\u4fe1\u606f\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int updateInfoImageManage(InfoImageManage record) {
        try {
            record.setUpdateDate(new Date());
            return this.ifoImageManageMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u56fe\u7247\u4fe1\u606f\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public InfoImageManage getInfoImageManageById(Long imageManageId) {
        InfoImageManage infoImageManage = null;
        try {
            infoImageManage = this.ifoImageManageMapper.selectByPrimaryKey(imageManageId);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636eID\u67e5\u8be2\u56fe\u7247\u4fe1\u606f\u9519\u8bef:", e);
        }
        return infoImageManage;
    }

    @Override
    public Integer selectImageManageCountByClassifyId(Long classifyId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CLASSIFYID, classifyId);
            return this.ifoImageManageMapper.selectImageManageCountByParam(map);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u7c7b\u578bID\u67e5\u8be2\u56fe\u7247\u4fe1\u606f\u6570\u91cf\u9519\u8bef:", e);
            return -1;
        }
    }

    @Override
    public PageBean selectImageManageByParam(PageBean pb, Long classifyId, String startDate, String endDate, Long thirdId) {
        try {
            pb.setPageSize(8);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CLASSIFYID, classifyId);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put(THIRDID, thirdId);
            pb.setRows(this.ifoImageManageMapper.selectImageManageCountByParam(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.ifoImageManageMapper.selectImageManageByParam(map));
            return pb;
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO1, e);
            return null;
        }
    }

    public InfoImageManageMapper getIfoImageManageMapper() {
        return this.ifoImageManageMapper;
    }

    @Resource(name="InfoImageManageMapper")
    public void setIfoImageManageMapper(InfoImageManageMapper ifoImageManageMapper) {
        this.ifoImageManageMapper = ifoImageManageMapper;
    }

    @Override
    public PageBean selectImageByThirdId(PageBean pb, Long thirdId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(THIRDID, thirdId);
            pb.setRows(this.ifoImageManageMapper.selectImageManageCountByParam(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.ifoImageManageMapper.selectImageManageByParam(map));
            return pb;
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO1, e);
            return null;
        }
    }

    @Override
    public Integer updateImage(Long imageManageId, Long thirdId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("imageManageId", imageManageId);
        param.put(THIRDID, thirdId);
        return this.ifoImageManageMapper.updateImage(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateImages(Long[] imageManageIds, Long thirdId) {
        ArrayList<Long> imageIds = new ArrayList<Long>();
        for (int i = 0; i < imageManageIds.length; ++i) {
            imageIds.add(imageManageIds[i]);
        }
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("imageId", imageIds);
            param.put(THIRDID, thirdId);
            this.ifoImageManageMapper.updateImages(param);
        }
        finally {
            imageIds = null;
        }
    }

    @Override
    public PageBean selectImageManageByParam(PageBean pb, Long classifyId, Long thirdId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CLASSIFYID, classifyId);
            map.put(THIRDID, thirdId);
            pb.setRows(this.ifoImageManageMapper.selectImageManageCountByParam(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.ifoImageManageMapper.selectImageManageByParam(map));
            return pb;
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO1, e);
            return null;
        }
    }

    @Override
    public void saveImage(String imageSrc) {
        InfoImageManage infoImageManage = new InfoImageManage();
        infoImageManage.setImageManageUrl(imageSrc);
        infoImageManage.setImageOnlineDate(new Date());
        this.saveInfoImageManage(infoImageManage);
    }
}

