/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.index.service.impl;

import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.bean.GoodsCate;
import com.qianjiang.channel.dao.ChannelAdverMapper;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.index.bean.IndexAdvertBean;
import com.qianjiang.index.bean.IndexBrandBean;
import com.qianjiang.index.bean.IndexCate;
import com.qianjiang.index.bean.IndexClassifyBar;
import com.qianjiang.index.bean.IndexClassifyBarBean;
import com.qianjiang.index.bean.IndexFloor;
import com.qianjiang.index.bean.IndexGoodsBean;
import com.qianjiang.index.bean.IndexSiteStoreyBean;
import com.qianjiang.index.bean.IndexStoreyTagBean;
import com.qianjiang.index.service.IndexSiteService;
import com.qianjiang.temp.service.ClassifyBarCateService;
import com.qianjiang.temp.service.ClassifyBarQuickService;
import com.qianjiang.temp.service.ClassifyBarService;
import com.qianjiang.temp.vo.ClassifyBarVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="IndexSiteService")
public class IndexSiteServiceImpl
implements IndexSiteService {
    private static final Long ATID3 = 161L;
    private static final Long ADVERTTYPE = 151L;
    private ChannelStoreyService channelStoreyService;
    private ChannelStoreyGoodsService channelStoreyGoodsService;
    private ChannelAdverService channelAdverService;
    private ChannelTrademarkService channelTrademarkService;
    private ChannelStoreyTagService channelStoreyTagService;
    private GoodsCateService goodsCateService;
    private ClassifyBarService classifyBarService;
    @Resource(name="ClassifyBarCateService")
    private ClassifyBarCateService barCateService;
    @Resource(name="ClassifyBarQuickService")
    private ClassifyBarQuickService barQuickService;
    @Resource(name="ChannelAdverMapper")
    private ChannelAdverMapper channelAdverMapper;

    @Override
    public IndexClassifyBar getClassifyBar(Long tempId) {
        IndexClassifyBar indexClassifyBar = new IndexClassifyBar();
        this.getBoxAdvertList(tempId, indexClassifyBar);
        this.getBoxBrandList(tempId, indexClassifyBar);
        this.getClassifyBar(tempId, indexClassifyBar);
        return indexClassifyBar;
    }

    private void getClassifyBar(Long tempId, IndexClassifyBar indexClassifyBar) {
        List<ClassifyBarVo> classifyBar = this.classifyBarService.selectClassifyBarByParamSite(tempId, null, null);
        for (ClassifyBarVo cbv : classifyBar) {
            IndexClassifyBarBean cb = new IndexClassifyBarBean();
            cb.setClassifyBarId(cbv.getClassifyBarId());
            cb.setGoodsCatId(cbv.getGoodsCatId());
            cb.setName(cbv.getName());
            cb.setUrl(cbv.getUrl());
            cb.setImgSrc(cbv.getTemp2());
            cb.setChilds(cbv.getChilds());
            cb.setImgString(cbv.getTemp5());
            cb.setBarCate(this.barCateService.selectByClassifyBarId(cbv.getClassifyBarId()));
            cb.setBarQuick(this.barQuickService.selectByClassifyBarId(cbv.getClassifyBarId()));
            this.getClassifyAdvertList(cb);
            this.getClassifyBrandList(cb);
            indexClassifyBar.getClassifyBarList().add(cb);
        }
    }

    private void getClassifyBrandList(IndexClassifyBarBean cb) {
        List<ChannelTrademark> brandList = this.channelTrademarkService.selectChannelTrademarkByParamForSite(null, null, null, null, cb.getClassifyBarId().toString(), null, null);
        for (ChannelTrademark brand : brandList) {
            IndexBrandBean indexBrandBean = new IndexBrandBean();
            indexBrandBean.setTrademarkId(brand.getChannelTrademarkId());
            indexBrandBean.setTrademarkName(brand.getTrademarkName());
            indexBrandBean.setLogoSrc(brand.getLogoSrc());
            indexBrandBean.setDes(brand.getDes());
            indexBrandBean.setSort(brand.getSort());
            indexBrandBean.setUrl(brand.getUrl());
            indexBrandBean.setShowType(brand.getShowType());
            indexBrandBean.setTitle(brand.getTitle());
            indexBrandBean.setBrandId(brand.getTemp4());
            cb.getIndexBrandList().add(indexBrandBean);
        }
    }

    private void getClassifyAdvertList(IndexClassifyBarBean cb) {
        List<ChannelAdver> adverList = this.channelAdverService.selectchannelAdverByParamForSite(null, null, null, null, ATID3, ADVERTTYPE, cb.getClassifyBarId().toString(), null, null, null);
        for (ChannelAdver channelAdver : adverList) {
            IndexAdvertBean indexAdvertBean = new IndexAdvertBean();
            indexAdvertBean.setAdverName(channelAdver.getAdverName());
            indexAdvertBean.setAdverPath(channelAdver.getAdverPath());
            indexAdvertBean.setAdverHref(channelAdver.getAdverHref());
            indexAdvertBean.setAdverSort(channelAdver.getAdverSort());
            indexAdvertBean.setTemp2(channelAdver.getTemp2());
            indexAdvertBean.setDes(channelAdver.getDes());
            indexAdvertBean.setChannelAdverId(channelAdver.getChannelAdverId());
            cb.getIndexAdvertList().add(indexAdvertBean);
        }
    }

    private void getBoxBrandList(Long tempId, IndexClassifyBar indexClassifyBar) {
        List<ChannelTrademark> boxBrandList = this.channelTrademarkService.selectChannelTrademarkByParamForSite(null, tempId, null, null, null, "1", null);
        for (ChannelTrademark brand : boxBrandList) {
            IndexBrandBean indexBrandBean = new IndexBrandBean();
            indexBrandBean.setTrademarkId(brand.getChannelTrademarkId());
            indexBrandBean.setTrademarkName(brand.getTrademarkName());
            indexBrandBean.setLogoSrc(brand.getLogoSrc());
            indexBrandBean.setDes(brand.getDes());
            indexBrandBean.setSort(brand.getSort());
            indexBrandBean.setTitle(brand.getTitle());
            indexClassifyBar.getIndexBrandList().add(indexBrandBean);
        }
    }

    private void getBoxAdvertList(Long tempId, IndexClassifyBar indexClassifyBar) {
        List<ChannelAdver> boxAdverList = this.channelAdverService.selectchannelAdverByParamForSite(null, tempId, null, null, ATID3, ADVERTTYPE, null, "1", null, null);
        for (ChannelAdver channelAdver : boxAdverList) {
            IndexAdvertBean indexAdvertBean = new IndexAdvertBean();
            indexAdvertBean.setAdverName(channelAdver.getAdverName());
            indexAdvertBean.setAdverPath(channelAdver.getAdverPath());
            indexAdvertBean.setAdverHref(channelAdver.getAdverHref());
            indexAdvertBean.setAdverSort(channelAdver.getAdverSort());
            indexAdvertBean.setTemp2(channelAdver.getTemp2());
            indexAdvertBean.setDes(channelAdver.getDes());
            indexAdvertBean.setChannelAdverId(channelAdver.getChannelAdverId());
            indexClassifyBar.getIndexAdvertList().add(indexAdvertBean);
        }
    }

    @Override
    public IndexFloor getStoreys(Long tempId) {
        IndexFloor indexFloor = new IndexFloor();
        List<ChannelStorey> storeyList = this.channelStoreyService.selectchannelStoreyByParamForSite(null, tempId, null);
        for (ChannelStorey s : storeyList) {
            IndexSiteStoreyBean storeys = new IndexSiteStoreyBean();
            storeys.setChannelStoreyId(s.getChannelStoreyId());
            storeys.setStoreyName(s.getStoreyName());
            storeys.setStoreySeo(s.getStoreySeo());
            storeys.setStoreyImg(s.getStoreyImg());
            storeys.setStoreyImgHref(s.getStoreyImgHref());
            storeys.setFloorId(s.getFloorId());
            storeys.setGoodsCatId(s.getGoodsCatId());
            storeys.setTempId(s.getTempId());
            storeys.setStoreyRightImg(s.getTemp2());
            this.getGoodsCateListForStorey(s, storeys);
            this.getGoodsListForStorey(s, storeys);
            this.getGeneralAdverListForStorey(s, storeys);
            this.getRotationAdverListForStorey(s, storeys);
            this.getTagAdverListForStorey(s, storeys);
            indexFloor.getFloorList().add(storeys);
        }
        return indexFloor;
    }

    @Override
    public List<IndexStoreyTagBean> getTagListForTempId(Long tempId) {
        ArrayList<IndexStoreyTagBean> tags = new ArrayList<IndexStoreyTagBean>();
        List<ChannelStoreyTag> tagList = this.channelStoreyTagService.selectchannelStoreyTagByParamForSite(null, tempId, null);
        for (ChannelStoreyTag tag : tagList) {
            IndexStoreyTagBean storeyTag = new IndexStoreyTagBean();
            storeyTag.setChannelStoreyTagId(tag.getChannelStoreyTagId());
            storeyTag.setName(tag.getName());
            storeyTag.setSort(tag.getSort());
            this.getGoodsListForStoreyTag(storeyTag);
            this.getAdvertListForStoreyTag(storeyTag);
            this.getBrandListForStoreyTag(storeyTag);
            tags.add(storeyTag);
        }
        return tags;
    }

    private void getTagListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        List<ChannelStoreyTag> tagList = this.channelStoreyTagService.selectchannelStoreyTagByParamForSite(s.getChannelStoreyId(), null, null);
        for (ChannelStoreyTag tag : tagList) {
            IndexStoreyTagBean storeyTag = new IndexStoreyTagBean();
            storeyTag.setChannelStoreyTagId(tag.getChannelStoreyTagId());
            storeyTag.setName(tag.getName());
            storeyTag.setSort(tag.getSort());
            this.getGoodsListForStoreyTag(storeyTag);
            this.getAdvertListForStoreyTag(storeyTag);
            this.getBrandListForStoreyTag(storeyTag);
            storeys.getIndexStoreyTagList().add(storeyTag);
        }
    }

    private void getBrandListForStoreyTag(IndexStoreyTagBean storeyTag) {
        List<ChannelTrademark> tagBrandList = this.channelTrademarkService.selectChannelTrademarkByParamForSite(null, null, null, storeyTag.getChannelStoreyTagId(), null, null, null);
        for (ChannelTrademark brand : tagBrandList) {
            IndexBrandBean indexBrandBean = new IndexBrandBean();
            indexBrandBean.setTrademarkId(brand.getChannelTrademarkId());
            indexBrandBean.setTrademarkName(brand.getTrademarkName());
            indexBrandBean.setLogoSrc(brand.getLogoSrc());
            indexBrandBean.setDes(brand.getDes());
            indexBrandBean.setSort(brand.getSort());
            indexBrandBean.setBrandId(brand.getTemp4());
            storeyTag.getIndexBrandList().add(indexBrandBean);
        }
    }

    private void getAdvertListForStoreyTag(IndexStoreyTagBean storeyTag) {
        List<ChannelAdver> tagAdverList = this.channelAdverService.selectchannelAdverByParamForSite(null, null, null, storeyTag.getChannelStoreyTagId(), ATID3, ADVERTTYPE, null, "0", null, null);
        for (ChannelAdver channelAdver : tagAdverList) {
            IndexAdvertBean indexAdvertBean = new IndexAdvertBean();
            indexAdvertBean.setAdverName(channelAdver.getAdverName());
            indexAdvertBean.setAdverPath(channelAdver.getAdverPath());
            indexAdvertBean.setAdverHref(channelAdver.getAdverHref());
            indexAdvertBean.setAdverSort(channelAdver.getAdverSort());
            indexAdvertBean.setTemp2(channelAdver.getTemp2());
            indexAdvertBean.setDes(channelAdver.getDes());
            indexAdvertBean.setChannelAdverId(channelAdver.getChannelAdverId());
            storeyTag.getIndexAdvertList().add(indexAdvertBean);
        }
    }

    private void getGoodsListForStoreyTag(IndexStoreyTagBean storeyTag) {
        List<ChannelStoreyGoods> tagGoodsList = this.channelStoreyGoodsService.selectchannelStoreyGoodsByParamForSite(null, storeyTag.getChannelStoreyTagId(), null);
        for (int i = 0; i < tagGoodsList.size(); ++i) {
            IndexGoodsBean indexGoodsBean = new IndexGoodsBean();
            indexGoodsBean.setName(tagGoodsList.get(i).getGoodsproductName());
            indexGoodsBean.setNumber(String.valueOf(tagGoodsList.get(i).getGoodsproductNo()));
            indexGoodsBean.setPrice(String.valueOf(tagGoodsList.get(i).getGoodsproductPrice()));
            indexGoodsBean.setUrlpic(tagGoodsList.get(i).getGoodsproductImgsrc());
            indexGoodsBean.setId(String.valueOf(tagGoodsList.get(i).getGoodsproductId()));
            storeyTag.getIndexGoodsList().add(indexGoodsBean);
        }
    }

    private void getBrandListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        List<ChannelTrademark> brandList = this.channelTrademarkService.selectChannelTrademarkByParamForSite(null, null, s.getChannelStoreyId(), null, null, null, null);
        for (ChannelTrademark brand : brandList) {
            IndexBrandBean indexBrandBean = new IndexBrandBean();
            indexBrandBean.setTrademarkId(brand.getChannelTrademarkId());
            indexBrandBean.setTrademarkName(brand.getTrademarkName());
            indexBrandBean.setLogoSrc(brand.getLogoSrc());
            indexBrandBean.setDes(brand.getDes());
            indexBrandBean.setTemp5(brand.getTemp5());
            indexBrandBean.setSort(brand.getSort());
            storeys.getIndexBrandList().add(indexBrandBean);
        }
    }

    private void getAdvertListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        List<ChannelAdver> adverList = this.channelAdverService.selectchannelAdverByParamForSite(null, null, s.getChannelStoreyId(), null, ATID3, ADVERTTYPE, null, "0", null, null);
        for (ChannelAdver channelAdver : adverList) {
            IndexAdvertBean indexAdvertBean = new IndexAdvertBean();
            indexAdvertBean.setAdverName(channelAdver.getAdverName());
            indexAdvertBean.setAdverPath(channelAdver.getAdverPath());
            indexAdvertBean.setAdverHref(channelAdver.getAdverHref());
            indexAdvertBean.setAdverSort(channelAdver.getAdverSort());
            indexAdvertBean.setTemp2(channelAdver.getTemp2());
            indexAdvertBean.setDes(channelAdver.getDes());
            indexAdvertBean.setChannelAdverId(channelAdver.getChannelAdverId());
            storeys.getIndexAdvertList().add(indexAdvertBean);
        }
    }

    private void getGoodsListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        List<ChannelStoreyGoods> storeyGoodsList = this.channelStoreyGoodsService.selectchannelStoreyGoodsByParamForSite(s.getChannelStoreyId(), null, null);
        for (int i = 0; i < storeyGoodsList.size(); ++i) {
            IndexGoodsBean indexGoodsBean = new IndexGoodsBean();
            indexGoodsBean.setName(storeyGoodsList.get(i).getGoodsproductName());
            indexGoodsBean.setNumber(String.valueOf(storeyGoodsList.get(i).getGoodsproductNo()));
            indexGoodsBean.setPrice(String.valueOf(storeyGoodsList.get(i).getGoodsproductPrice()));
            indexGoodsBean.setUrlpic(storeyGoodsList.get(i).getGoodsproductImgsrc());
            indexGoodsBean.setId(String.valueOf(storeyGoodsList.get(i).getGoodsproductId()));
            storeys.getIndexGoodsList().add(indexGoodsBean);
        }
    }

    private void getGoodsCateListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        List<GoodsCate> listcate = this.goodsCateService.queryCatIdsByCatId(s.getGoodsCatId());
        listcate.remove(0);
        for (int i = 0; i < listcate.size(); ++i) {
            IndexCate indexCate = new IndexCate();
            indexCate.setId(listcate.get(i).getCatId());
            indexCate.setName(listcate.get(i).getCatName());
            storeys.getIndexCateList().add(indexCate);
        }
    }

    private void getGeneralAdverListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        Long channelStoreyId = s.getChannelStoreyId();
        Integer floorStyle = s.getFloorId();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("floorId", channelStoreyId);
        paramMap.put("floorStyle", floorStyle);
        paramMap.put("adverFlag", 1);
        List<ChannelAdver> generalAdver = this.channelAdverMapper.queryByParam(paramMap);
        for (ChannelAdver channelAdver : generalAdver) {
            IndexAdvertBean indexAdvertBean = new IndexAdvertBean();
            indexAdvertBean.setAdverName(channelAdver.getAdverName());
            indexAdvertBean.setAdverPath(channelAdver.getAdverPath());
            indexAdvertBean.setAdverHref(channelAdver.getAdverHref());
            indexAdvertBean.setAdverSort(channelAdver.getAdverSort());
            indexAdvertBean.setTemp2(channelAdver.getTemp2());
            indexAdvertBean.setDes(channelAdver.getDes());
            indexAdvertBean.setChannelAdverId(channelAdver.getChannelAdverId());
            storeys.getIndexGeneralAdverList().add(indexAdvertBean);
        }
    }

    private void getRotationAdverListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        Long channelStoreyId = s.getChannelStoreyId();
        Integer floorStyle = s.getFloorId();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("floorId", channelStoreyId);
        paramMap.put("floorStyle", floorStyle);
        paramMap.put("adverFlag", 2);
        List<ChannelAdver> rotationAdver = this.channelAdverMapper.queryByParam(paramMap);
        for (ChannelAdver channelAdver : rotationAdver) {
            IndexAdvertBean indexAdvertBean = new IndexAdvertBean();
            indexAdvertBean.setAdverName(channelAdver.getAdverName());
            indexAdvertBean.setAdverPath(channelAdver.getAdverPath());
            indexAdvertBean.setAdverHref(channelAdver.getAdverHref());
            indexAdvertBean.setAdverSort(channelAdver.getAdverSort());
            indexAdvertBean.setTemp2(channelAdver.getTemp2());
            indexAdvertBean.setDes(channelAdver.getDes());
            indexAdvertBean.setChannelAdverId(channelAdver.getChannelAdverId());
            storeys.getIndexRotationAdversList().add(indexAdvertBean);
        }
    }

    private void getTagAdverListForStorey(ChannelStorey s, IndexSiteStoreyBean storeys) {
        Long channelStoreyId = s.getChannelStoreyId();
        Integer floorStyle = s.getFloorId();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("floorId", channelStoreyId);
        paramMap.put("floorStyle", floorStyle);
        paramMap.put("adverFlag", 3);
        List<ChannelAdver> tagAdver = this.channelAdverMapper.queryByParam(paramMap);
        for (ChannelAdver channelAdver : tagAdver) {
            IndexAdvertBean indexAdvertBean = new IndexAdvertBean();
            indexAdvertBean.setAdverName(channelAdver.getAdverName());
            indexAdvertBean.setAdverPath(channelAdver.getAdverPath());
            indexAdvertBean.setAdverHref(channelAdver.getAdverHref());
            indexAdvertBean.setAdverSort(channelAdver.getAdverSort());
            indexAdvertBean.setTemp2(channelAdver.getTemp2());
            indexAdvertBean.setDes(channelAdver.getDes());
            indexAdvertBean.setChannelAdverId(channelAdver.getChannelAdverId());
            storeys.getIndexTagAdversList().add(indexAdvertBean);
        }
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="ChannelGoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public ChannelStoreyService getChannelStoreyService() {
        return this.channelStoreyService;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyService(ChannelStoreyService channelStoreyService) {
        this.channelStoreyService = channelStoreyService;
    }

    public ChannelStoreyGoodsService getChannelStoreyGoodsService() {
        return this.channelStoreyGoodsService;
    }

    @Resource(name="ChannelStoreyGoodsService")
    public void setChannelStoreyGoodsService(ChannelStoreyGoodsService channelStoreyGoodsService) {
        this.channelStoreyGoodsService = channelStoreyGoodsService;
    }

    public ChannelAdverService getChannelAdverService() {
        return this.channelAdverService;
    }

    @Resource(name="ChannelAdverService")
    public void setChannelAdverService(ChannelAdverService channelAdverService) {
        this.channelAdverService = channelAdverService;
    }

    public ChannelTrademarkService getChannelTrademarkService() {
        return this.channelTrademarkService;
    }

    @Resource(name="ChannelTrademarkService")
    public void setChannelTrademarkService(ChannelTrademarkService channelTrademarkService) {
        this.channelTrademarkService = channelTrademarkService;
    }

    public ChannelStoreyTagService getChannelStoreyTagService() {
        return this.channelStoreyTagService;
    }

    @Resource(name="ChannelStoreyTagService")
    public void setChannelStoreyTagService(ChannelStoreyTagService channelStoreyTagService) {
        this.channelStoreyTagService = channelStoreyTagService;
    }

    public ClassifyBarService getClassifyBarService() {
        return this.classifyBarService;
    }

    @Resource(name="ClassifyBarService")
    public void setClassifyBarService(ClassifyBarService classifyBarService) {
        this.classifyBarService = classifyBarService;
    }
}

