/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.service.impl;

import com.qianjiang.information.bean.Information;
import com.qianjiang.information.dao.ThirdInforMapper;
import com.qianjiang.information.service.ThirdInforService;
import com.qianjiang.information.vo.InformationVo;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ThirdInforService")
public class ThirdInforServiceImpl
implements ThirdInforService {
    private static final String TEMP2 = "temp2";
    @Resource(name="ThirdInforMapper")
    private ThirdInforMapper informationMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBean(PageBean pb, String searchText, Long typeId, String thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("searchText", searchText);
            map.put("typeId", typeId);
            map.put(TEMP2, thirdId);
            pb.setRows(this.informationMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.informationMapper.queryByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public int delInfo(Long infoId) {
        return this.informationMapper.deleteByPrimaryKey(infoId);
    }

    @Override
    public void batchDelInfo(Long[] ids) {
        if (null != ids && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                this.delInfo(ids[i]);
            }
        }
    }

    @Override
    public int saveInfo(Information record) {
        Date date = new Date();
        record.setDelflag("0");
        record.setTemp1("1");
        record.setCreateDate(date);
        record.setUpdateDate(date);
        return this.informationMapper.insert(record);
    }

    @Override
    public int updateInfo(Information record) {
        record.setUpdateDate(new Date());
        return this.informationMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public Information selectByPrimaryKey(Long infoId) {
        return this.informationMapper.selectByPrimaryKey(infoId);
    }

    @Override
    public List<InformationVo> selectAll(String thirdId) {
        return this.informationMapper.selectAll(thirdId);
    }

    @Override
    public boolean checkDelInfoTypeByInfoCount(Long infoTypeId) {
        return this.informationMapper.selectInfoCountByTypeId(infoTypeId) <= 0;
    }

    @Override
    public boolean checkAddInfoByTitle(String title, String thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put(TEMP2, thirdId);
        return this.informationMapper.selectInfoCountByTitle(map) <= 0;
    }

    @Override
    public boolean checkAddInfoByTitle(String title, String thirdId, Long infoId) {
        Information info = this.informationMapper.selectByPrimaryKey(infoId);
        if (null != info) {
            if (info.getTitle().equals(title)) {
                return true;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("title", title);
            map.put(TEMP2, thirdId);
            return this.informationMapper.selectInfoCountByTitle(map) <= 0;
        }
        return false;
    }

    @Override
    public List<InformationVo> selectByInfoType(Long infoTypeId) {
        return this.informationMapper.selectByInfoType(infoTypeId);
    }
}

