/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.service.impl;

import com.qianjiang.manager.bean.Manager;
import com.qianjiang.manager.bean.ManagerAuthority;
import com.qianjiang.manager.bean.valuebean.MenuVo;
import com.qianjiang.manager.domain.ReLoginDomain;
import com.qianjiang.manager.mapper.ManagerAuthorityMapper;
import com.qianjiang.manager.mapper.ManagerMapper;
import com.qianjiang.manager.service.AuthorityServiceInterface;
import com.qianjiang.manager.service.ManagerServiceInterface;
import com.qianjiang.manager.service.MenuServiceInterface;
import com.qianjiang.util.PageBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="managerService")
public class ManagerService
implements ManagerServiceInterface {
    private static final int MANAGER_BASE_CODE = 10000;
    private static final int THIRD = 3;
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private MenuServiceInterface menuServiceInterface;
    private ManagerAuthorityMapper managerAuthorityMapper;
    private AuthorityServiceInterface authorityServiceInterface;
    private ManagerMapper managerMapper;
    private Manager manager;

    @Override
    public ReLoginDomain ifManager(String name, String password) {
        Long existsFlag = this.managerMapper.checkexistsByCustName(name);
        HashMap<String, Object> paramMap = null;
        ReLoginDomain reLoginDomain = new ReLoginDomain();
        reLoginDomain.setBcode(0);
        if (!"0".equals(existsFlag.toString())) {
            paramMap = new HashMap<String, Object>();
            paramMap.put(USERNAME, name);
            paramMap.put(PASSWORD, password);
            this.manager = this.managerMapper.selectCustomerByNamePwd(paramMap);
            if (this.manager != null && "0".equals(this.manager.getFlag())) {
                reLoginDomain.setName(name);
                reLoginDomain.setLoginUserId(this.manager.getId());
                reLoginDomain.setPhotoImg(this.manager.getPhotoImg());
                reLoginDomain.setManagerFlag(this.authorityServiceInterface.queryAuthorByManagerId(this.manager.getId()).getAuthorityId().equals(this.authorityServiceInterface.querySupperAuthor().getId()) ? 1 : 0);
                this.managerMapper.updateByPrimaryKey(this.manager);
                reLoginDomain.setBcode(1);
                reLoginDomain.setCode(10000 + this.manager.getId().intValue());
            } else if (this.manager != null && !"0".equals(this.manager.getFlag())) {
                reLoginDomain.setCode(3);
            } else {
                reLoginDomain.setCode(2);
            }
        } else {
            reLoginDomain.setCode(0);
        }
        return reLoginDomain;
    }

    @Override
    public List<MenuVo> queryMenuByMangerName(String name) {
        if (this.queryManagerByName(name) == null) {
            return Collections.emptyList();
        }
        return this.menuServiceInterface.getMenuLists(this.queryManagerByName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryManagerList(Manager manager, PageBean pageBean, Long createId) {
        Integer no = 0;
        try {
            manager.setCreateId(createId);
            pageBean.setRows(this.managerMapper.queryManagerCount(manager));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            if (manager != null) {
                manager.setStartRowNum(pageBean.getStartRowNum());
                manager.setEndRowNum(pageBean.getEndRowNum());
            }
            pageBean.setObjectBean(manager);
            pageBean.setList(this.managerMapper.selectManagerByManager(manager));
        }
        finally {
            no = null;
        }
        return pageBean;
    }

    @Override
    public int addManager(Manager manager, String authorityId) {
        return this.managerMapper.addManager(manager, authorityId);
    }

    @Override
    public Manager queryManagerById(Long id) {
        return this.managerMapper.selectById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteManager(String[] parameterIds) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            if (null != parameterIds && parameterIds.length > 0) {
                paramMap.put("parameterIds", parameterIds);
                count = this.managerMapper.delectMangerByIds(paramMap);
                this.managerAuthorityMapper.deleteByManagerIds(paramMap);
            }
            int n = count;
            return n;
        }
        finally {
            count = null;
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enabledManager(String[] parameterIds) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            if (null != parameterIds && parameterIds.length > 0) {
                paramMap.put("parameterIds", parameterIds);
                count = this.managerMapper.enabledMangerByIds(paramMap);
                this.managerAuthorityMapper.enabledByManagerIds(paramMap);
            }
            int n = count;
            return n;
        }
        finally {
            count = null;
            paramMap = null;
        }
    }

    @Override
    public int updateManager(Manager manager, ManagerAuthority authority) {
        int count = this.managerMapper.updateByPrimaryKeySelective(manager);
        if (count == 1) {
            authority.setManagerId(manager.getId());
            count += this.managerAuthorityMapper.updateByPrimaryKeySelective(authority);
        }
        return count;
    }

    @Override
    public Manager queryManagerByName(String name) {
        return this.managerMapper.selectByName(name);
    }

    @Override
    public Manager queryDelManagerByName(String name) {
        return this.managerMapper.selectDelManagerByName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUserKey(String name, String userKey) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(USERNAME, name);
            paramMap.put(PASSWORD, userKey);
            this.manager = this.managerMapper.selectCustomerByNamePwd(paramMap);
            if (this.manager != null) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int modifiedUserKey(String name, String userKey, String newuserkey) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(USERNAME, name);
            paramMap.put(PASSWORD, userKey);
            this.manager = this.managerMapper.selectCustomerByNamePwd(paramMap);
            if (this.manager != null) {
                this.manager.setUserkey(newuserkey);
                if (this.managerMapper.updateByPrimaryKeySelective(this.manager) == 1) {
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int modifiedPwd(String name, String userKey, String newuserkey) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(USERNAME, name);
            paramMap.put(PASSWORD, userKey);
            this.manager = this.managerMapper.selectManagerByNamePwd(paramMap);
            if (this.manager != null) {
                this.manager.setUserkey(newuserkey);
                if (this.managerMapper.updateByPrimaryKeySelective(this.manager) == 1) {
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public Long checkManagerExist(String username) {
        return this.managerMapper.checkexistsByCustName(username);
    }

    @Override
    public int updateManagerOnly(Manager manager) {
        return this.managerMapper.updateByPrimaryKeySelective(manager);
    }

    @Override
    public void stopCloudAccountByTime() {
        System.out.println("========\u81ea\u52a8\u51bb\u7ed3\u8fc7\u671f\u8d26\u53f7==========");
        List<Manager> managers = this.managerMapper.queryCloudManagerList();
        if (managers != null) {
            for (int i = 0; i < managers.size(); ++i) {
                if (managers.get(i).getCreateTime() == null || System.currentTimeMillis() - managers.get(i).getCreateTime().getTime() <= 604800000L) continue;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("id", managers.get(i).getId());
                this.managerMapper.delectMangerByIds(paramMap);
                this.managerAuthorityMapper.deleteByManagerIds(paramMap);
            }
        }
    }

    @Override
    public Manager selectByName(String name) {
        return this.managerMapper.selectByName(name);
    }

    public ManagerAuthorityMapper getManagerAuthorityMapper() {
        return this.managerAuthorityMapper;
    }

    @Resource(name="managerAuthorityMapper")
    public void setManagerAuthorityMapper(ManagerAuthorityMapper managerAuthorityMapper) {
        this.managerAuthorityMapper = managerAuthorityMapper;
    }

    public MenuServiceInterface getMenuServiceInterface() {
        return this.menuServiceInterface;
    }

    @Resource(name="menuServiceInterface")
    public void setMenuServiceInterface(MenuServiceInterface menuServiceInterface) {
        this.menuServiceInterface = menuServiceInterface;
    }

    public ManagerMapper getManagerMapper() {
        return this.managerMapper;
    }

    @Resource(name="managerMapper")
    public void setManagerMapper(ManagerMapper managerMapper) {
        this.managerMapper = managerMapper;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public AuthorityServiceInterface getAuthorityServiceInterface() {
        return this.authorityServiceInterface;
    }

    @Resource(name="authorityService")
    public void setAuthorityServiceInterface(AuthorityServiceInterface authorityServiceInterface) {
        this.authorityServiceInterface = authorityServiceInterface;
    }
}

