/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.service.impl;

import com.qianjiang.manager.bean.Page;
import com.qianjiang.manager.bean.valuebean.MenuVo;
import com.qianjiang.manager.mapper.PageMapper;
import com.qianjiang.manager.service.PageServiceInterface;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository(value="PageService")
public class PageService
implements PageServiceInterface {
    private PageMapper pagemapper;

    public PageMapper getPagemapper() {
        return this.pagemapper;
    }

    @Resource(name="PageMapperImpl")
    public void setPagemapper(PageMapper pagemapper) {
        this.pagemapper = pagemapper;
    }

    @Override
    public int savePage(Page page) {
        page.setFlag("0");
        if (page.getParentId() == null) {
            page.setParentId(0L);
        }
        if (page.getParentId() == 0L) {
            page.setGrade(1L);
        } else {
            page.setGrade(this.pagemapper.selectByPrimaryKey(page.getParentId()).getGrade() + 1L);
        }
        return this.pagemapper.insertSelective(page);
    }

    @Override
    public int updatePage(Page page) {
        if (page.getParentId() == 0L) {
            page.setGrade(1L);
        } else {
            page.setGrade(this.pagemapper.selectByPrimaryKey(page.getParentId()).getGrade() + 1L);
        }
        return this.pagemapper.updateByPrimaryKeySelective(page);
    }

    @Override
    public int delPage(Long pageId) {
        return this.pagemapper.deleteByPrimaryKey(pageId);
    }

    @Override
    public int batchDelPage(Long[] pageIds) {
        Integer count = 0;
        if (null != pageIds && pageIds.length > 0) {
            for (int i = 0; i < pageIds.length; ++i) {
                count = count + this.delPage(pageIds[i]);
            }
        }
        return count;
    }

    @Override
    public Page queryPageByPrimaryKey(Long pageId) {
        return this.pagemapper.selectByPrimaryKey(pageId);
    }

    @Override
    public PageBean queryCateListByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        pb.setRows(this.pagemapper.queryTotalCount(map));
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.pagemapper.queryByPageBean(map));
        return pb;
    }

    @Override
    public List<MenuVo> queryAllMenuVo() {
        return this.pagemapper.queryAllMenuVo();
    }

    @Override
    public boolean checkDelWithPageId(Long pageId) {
        return this.pagemapper.querySonCountByParentId(pageId) <= 0;
    }

    @Override
    public List<Object> getCateList(PageBean pb, SelectBean selectBean) {
        selectBean.setCondition("");
        ArrayList<Object> cateVoList = new ArrayList<Object>();
        List<Object> parentList = this.queryCateListByPageBean(pb, selectBean).getList();
        List<MenuVo> allCateList = this.pagemapper.queryAllMenuVo();
        for (int i = 0; i < parentList.size(); ++i) {
            MenuVo menu = (MenuVo)parentList.get(i);
            MenuVo menuVo = new MenuVo();
            menuVo.setId(menu.getId());
            menuVo.setGrade(menu.getGrade());
            menuVo.setDesignation(menu.getDesignation());
            menuVo.setParentId(menu.getParentId());
            menuVo.setUrl(menu.getUrl());
            menuVo.setSort(menu.getSort());
            menuVo.setMenuVos(this.calcCateVo(menuVo.getId(), allCateList));
            cateVoList.add(menuVo);
        }
        return cateVoList;
    }

    @Override
    public List<MenuVo> calcCateVo(Long parentId, List<MenuVo> allmenuVo) {
        ArrayList<MenuVo> cateVoList = new ArrayList<MenuVo>();
        for (int i = 0; i < allmenuVo.size(); ++i) {
            if (!parentId.equals(allmenuVo.get(i).getParentId())) continue;
            MenuVo cate = allmenuVo.get(i);
            MenuVo cateVo = new MenuVo();
            cateVo.setId(cate.getId());
            cateVo.setGrade(cate.getGrade());
            cateVo.setDesignation(cate.getDesignation());
            cateVo.setParentId(cate.getParentId());
            cateVo.setUrl(cate.getUrl());
            List<MenuVo> allSonCate = this.calcCateVo(cate.getId(), allmenuVo);
            cateVo.setMenuVos(allSonCate);
            cateVoList.add(cateVo);
        }
        return cateVoList;
    }

    @Override
    public List<MenuVo> queryAllParentMenuVo() {
        return this.pagemapper.queryAllParentMenuVo();
    }

    @Override
    public List<MenuVo> queryAllChildrenMenuVo() {
        return this.pagemapper.queryAllChildrenMenuVo();
    }

    @Override
    public List<MenuVo> queryAllParentMenuVoByLogin(Long managerId) {
        return this.pagemapper.queryAllParentMenuVoByLogin(managerId);
    }

    @Override
    public int newBatchDelPage(Long pageId) {
        int count = 0;
        List<MenuVo> allCateList = this.pagemapper.queryAllMenuVo();
        List<Long> pageIds = this.calcCatePage(pageId, allCateList, new ArrayList<Long>());
        pageIds.add(pageId);
        for (int i = 0; i < pageIds.size(); ++i) {
            count += this.delPage(pageIds.get(i));
        }
        return count;
    }

    @Override
    public List<MenuVo> queryMenuByBundleName(String bundleName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bundleName", bundleName);
        return this.pagemapper.queryMenuByBundleName(paramMap);
    }

    @Override
    public void deleteMenuByBundleName(String bundleName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bundleName", bundleName);
        this.pagemapper.deleteMenuByBundleName(paramMap);
    }

    public List<Long> calcCatePage(Long pageId, List<MenuVo> allCateList, List<Long> list) {
        if (allCateList != null) {
            for (int i = 0; i < allCateList.size(); ++i) {
                if (!pageId.equals(allCateList.get(i).getParentId())) continue;
                list.add(allCateList.get(i).getId());
                this.calcCatePage(allCateList.get(i).getId(), allCateList, list);
            }
        }
        return list;
    }
}

