/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.service.impl;

import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.dao.MobHomePageMapper;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.mobile.vo.MobHomePageVo;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.xml.XmlUtil;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

@Service(value="MobHomePageService")
public class MobHomePageServiceImpl
implements MobHomePageService {
    static final String xmlFilePath = "templete/mobile/xml/9gdemo.xml";
    @Resource(name="MobHomePageMapper")
    private MobHomePageMapper mobHomePageMapper;

    @Override
    public void createHomePage(MobHomePage homePage, Long loginUserId) {
        homePage.setTemp2("0");
        homePage.setCreateDate(new Date());
        homePage.setUpdateDate(new Date());
        homePage.setUpdateUserId(loginUserId);
        this.mobHomePageMapper.insertSelective(homePage);
    }

    @Override
    public void updateHomePage(MobHomePage homePage, Long loginUserId) {
        homePage.setUpdateDate(new Date());
        homePage.setUpdateUserId(loginUserId);
        this.mobHomePageMapper.updateByPrimaryKeySelective(homePage);
    }

    @Override
    public MobHomePage selectHomePageByMerchantId(Long merchantId, String filePath, Long loginUserId) {
        MobHomePage homePage = this.mobHomePageMapper.selectByMerchantId(merchantId);
        if (null == homePage) {
            this.initHomePage(merchantId, null, null, filePath, loginUserId);
            homePage = this.mobHomePageMapper.selectByMerchantId(merchantId);
        }
        return homePage;
    }

    @Override
    public MobHomePage initHomePage(Long merchantId, String isThird, Long storeId, String filePath, Long loginUserId) {
        XmlUtil xmlUtil = new XmlUtil();
        String fileName = filePath + xmlFilePath;
        Document document = xmlUtil.parserXml(fileName);
        String xmlStr = xmlUtil.document2Str(document);
        MobHomePage homePage = new MobHomePage();
        homePage.setDoc(xmlStr);
        homePage.setDocBac(xmlStr);
        homePage.setMerchantId(merchantId);
        homePage.setUpdateDate(new Date());
        homePage.setUpdateUserId(loginUserId);
        if (StringUtils.isNotEmpty((String)isThird)) {
            homePage.setIsThird(isThird);
            homePage.setStoreId(storeId);
        }
        this.createHomePage(homePage, loginUserId);
        return homePage;
    }

    @Override
    public void makeHtml() {
        XmlUtil xmlUtil = new XmlUtil();
        xmlUtil.Transform("xmlFileName", "xslFileName", "htmlFileName");
    }

    @Override
    public void deleteHomePageById(Long homepageId) {
        this.mobHomePageMapper.deleteByPrimaryKey(homepageId);
    }

    @Override
    public MobHomePage getHomePageById(Long homepageId) {
        return this.mobHomePageMapper.selectByPrimaryKey(homepageId);
    }

    @Override
    public MobHomePage selectThirdMob(Long storeId) {
        return this.mobHomePageMapper.selectThirdMob(storeId);
    }

    @Override
    public void openHomePageByHIdAndMId(Long homepageId, Long merchantId) {
        this.mobHomePageMapper.updateByMerchantId(merchantId);
        MobHomePage mobHomePage = new MobHomePage();
        mobHomePage.setHomepageId(homepageId);
        mobHomePage.setMerchantId(merchantId);
        mobHomePage.setUpdateDate(new Date());
        this.mobHomePageMapper.updateByhomepageIdAndMerchantId(mobHomePage);
    }

    @Override
    public List<MobHomePage> selectAllUnstatusByMerchantId(Long merchantId) {
        return this.mobHomePageMapper.selectAllUnstatusByMerchantId(merchantId);
    }

    @Override
    public MobHomePage getCurrHomePageByMerchantId(Long merchantId) {
        return this.mobHomePageMapper.queryCurrHomePageByMerchantId(merchantId);
    }

    @Override
    public MobHomePage getCurrHomePageByStoreId(Long storeId) {
        return this.mobHomePageMapper.getCurrHomePageByStoreId(storeId);
    }

    @Override
    public PageBean selectMobPageByPb(MobHomePageVo vo, PageBean pageBean) throws Exception {
        int rows = this.mobHomePageMapper.selectCount(vo);
        pageBean.setRows(rows);
        if (rows > 0) {
            vo.setStartRowNum(pageBean.getStartRowNum());
            vo.setEndRowNum(pageBean.getEndRowNum());
            pageBean.setList(this.mobHomePageMapper.selectByPb(vo));
        }
        return pageBean;
    }

    @Override
    public int isUsed(Long[] homePageIds) throws Exception {
        MobHomePageVo vo = new MobHomePageVo();
        int count = 0;
        for (Long id : homePageIds) {
            MobHomePage page = this.mobHomePageMapper.selectByPrimaryKey(id);
            if (page != null && "1".equals(page.getTemp2())) {
                return -1;
            }
            vo.setExsisSubjectUrl("page/".concat(String.valueOf(id)).concat("htm"));
            count += this.mobHomePageMapper.selectCount(vo);
        }
        if (count > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    @Transactional
    public int deleteMobPage(Long[] homePageIds) throws Exception {
        for (Long id : homePageIds) {
            this.mobHomePageMapper.deleteByPrimaryKey(id);
        }
        return 1;
    }

    @Override
    @Transactional
    public Long addMobPage(MobHomePageVo vo, String filePath, Long loginUserId) throws Exception {
        Long tempId = vo.getTempId();
        MobHomePage homePage = new MobHomePage();
        if (tempId != null && tempId > 0L) {
            homePage = this.mobHomePageMapper.selectByPrimaryKey(tempId);
            homePage.setHomepageId(null);
        } else {
            XmlUtil xmlUtil = new XmlUtil();
            String fileName = filePath + xmlFilePath;
            Document document = xmlUtil.parserXml(fileName);
            String xmlStr = xmlUtil.document2Str(document);
            homePage.setDoc(xmlStr);
            homePage.setDocBac(xmlStr);
        }
        homePage.setCreateDate(new Date());
        homePage.setSort(0);
        homePage.setTitle("");
        homePage.setIsThird(vo.getIsThird());
        homePage.setStoreId(vo.getStoreId());
        homePage.setTemp2("0");
        homePage.setTemp3("0");
        homePage.setTemp4("1");
        homePage.setMerchantId(vo.getMerchantId());
        homePage.setUpdateDate(new Date());
        homePage.setUpdateUserId(loginUserId);
        homePage.setAuthor("");
        homePage.setHomeDesc("");
        homePage.setFriendDesc("");
        homePage.setHomeImg("");
        homePage.setLogo("");
        this.mobHomePageMapper.insertSelective(homePage);
        if (homePage.getHomepageId() != null) {
            return homePage.getHomepageId();
        }
        return 0L;
    }
}

