/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.service.impl;

import com.qianjiang.mobile.bean.MobStorey;
import com.qianjiang.mobile.dao.MobAdverMapper;
import com.qianjiang.mobile.dao.MobStoreyMapper;
import com.qianjiang.mobile.service.MobStoreyService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="MobStoreyService")
public class MobStoreyServiceImpl
implements MobStoreyService {
    @Resource(name="MobStoreyMapper")
    private MobStoreyMapper mobStoreyMapper;
    @Resource(name="MobAdverMapper")
    private MobAdverMapper mobAdverMapper;
    private static final MyLogger LOGGER = new MyLogger(MobStoreyServiceImpl.class);

    @Override
    public int deleteMobStorey(Long mobStoreyId) {
        int n = -1;
        try {
            n = this.mobAdverMapper.deleteByStoreyId(mobStoreyId);
            n += this.mobStoreyMapper.deleteByPrimaryKey(mobStoreyId);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u79fb\u52a8\u7248\u697c\u5c42\u53ca\u5176\u5e7f\u544a\u9519\u8bef\uff1a=>", e);
        }
        return n;
    }

    @Override
    public int createMobStorey(MobStorey mobStorey) {
        Date date = new Date();
        mobStorey.setCreateDate(date);
        mobStorey.setUpdateDate(date);
        return this.mobStoreyMapper.insertSelective(mobStorey);
    }

    @Override
    public int updateMobStorey(MobStorey mobStorey) {
        mobStorey.setUpdateDate(new Date());
        return this.mobStoreyMapper.updateByPrimaryKeySelective(mobStorey);
    }

    @Override
    public MobStorey getMobStorey(Long mobStoreyId) {
        return this.mobStoreyMapper.selectByPrimaryKey(mobStoreyId);
    }

    @Override
    public PageBean selectMobStoreyByPb(PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            pb.setRows(this.mobStoreyMapper.selectCount());
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.mobStoreyMapper.selectByPb(map));
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u79fb\u52a8\u7248\u697c\u5c42\u9519\u8bef\uff1a=>", e);
        }
        return pb;
    }

    @Override
    public List<MobStorey> selectMobStoreyForSite() {
        return this.mobStoreyMapper.selectAllForSite();
    }

    @Override
    public int changeMobStoreyUserdStatus(Long mobStoreyId) {
        MobStorey mobStorey = this.mobStoreyMapper.selectByPrimaryKey(mobStoreyId);
        if ("0".equals(mobStorey.getUserStatus())) {
            mobStorey.setUserStatus("1");
        } else {
            mobStorey.setUserStatus("0");
        }
        mobStorey.setUpdateDate(new Date());
        return this.mobStoreyMapper.updateByPrimaryKeySelective(mobStorey);
    }
}

