/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.store.service.impl;

import com.qianjiang.store.bean.GoodsCateGory;
import com.qianjiang.store.bean.StoreInfoVo;
import com.qianjiang.store.dao.StoreListMapper;
import com.qianjiang.store.service.StoreListService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="storeListService")
public class StoreListServiceImpl
implements StoreListService {
    public static final MyLogger LOGGER = new MyLogger(StoreListServiceImpl.class);
    @Resource(name="storeListMapper")
    private StoreListMapper storeListMapper;

    @Override
    public int deleteController(Long storeId, Long customerId) {
        return this.storeListMapper.deleteController(storeId, customerId);
    }

    @Override
    public int selectController(Long storeId, Long customerId) {
        return this.storeListMapper.IsCollection(storeId, customerId);
    }

    @Override
    public List<GoodsCateGory> selectgoodscatebyone() {
        return this.storeListMapper.selectgoodscatebyone();
    }

    @Override
    public PageBean setStoreNewProcudtList(PageBean pb, Long storeId) {
        pb.setList(this.storeListMapper.StoreNewProcudtList(storeId));
        pb.setRows(this.storeListMapper.selectStoreNewUpProductCount(storeId).intValue());
        return pb;
    }

    @Override
    public int addCollectionSeller(Long customerId, Long storeId) {
        return this.storeListMapper.addCollectionSeller(customerId, storeId);
    }

    @Override
    public PageBean selectStoreList(PageBean pb, Long cateId, Long customerId) {
        Long cateIdNew = cateId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (null != cateIdNew) {
                cateIdNew = cateIdNew == -1L ? null : cateIdNew;
            }
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            map.put("cateId", cateIdNew);
            if (cateIdNew == null) {
                map.put("isChoice", "1");
            }
            pb.setRows(this.storeListMapper.selectStoreNum(map) == null ? 0 : this.storeListMapper.selectStoreNum(map));
            List<Object> storeInfos = this.storeListMapper.selectStoreList(map);
            if (CollectionUtils.isNotEmpty(storeInfos)) {
                for (int i = 0; i < storeInfos.size(); ++i) {
                    Integer t_collection;
                    StoreInfoVo storeInfo = (StoreInfoVo)storeInfos.get(i);
                    if (null != storeInfo.getStoreId() && null != customerId) {
                        t_collection = this.storeListMapper.IsCollection(storeInfo.getStoreId(), customerId);
                        storeInfo.setIsCollection(t_collection == null ? 0 : t_collection);
                    }
                    if (null == storeInfo.getStoreId()) continue;
                    t_collection = this.storeListMapper.IsCollection(storeInfo.getStoreId(), null);
                    storeInfo.setCollectionNum(t_collection == null ? 0 : t_collection);
                }
            }
            pb.setList(storeInfos);
        }
        catch (Exception e) {
            LOGGER.error("", e);
        }
        return pb;
    }
}

