/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.auth.alipay.util;

import com.qianjiang.system.auth.alipay.util.AlipayCore;
import com.qianjiang.util.MyLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public final class AlipayNotify {
    private static final MyLogger LOGGER = new MyLogger(AlipayNotify.class);
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";

    private AlipayNotify() {
    }

    public static boolean verify(Map<String, String> params) {
        String mysign = AlipayNotify.getMysign(params);
        String responseTxt = "true";
        if (params.get("notify_id") != null) {
            responseTxt = AlipayNotify.verifyResponse(params.get("notify_id"));
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return mysign.equals(sign) && "true".equals(responseTxt);
    }

    private static String getMysign(Map<String, String> params) {
        Map<String, String> sParaNew = AlipayCore.paraFilter(params);
        return AlipayCore.buildMysign(sParaNew);
    }

    private static String verifyResponse(String notifyid) {
        String partner = "2088701536409180";
        String veryfyurl = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notifyid;
        return AlipayNotify.checkUrl(veryfyurl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        BufferedReader in = null;
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            inputLine = sb.toString();
        }
        catch (Exception e) {
            LOGGER.error("", e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("", e);
            }
        }
        return inputLine;
    }
}

