/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.City;
import com.qianjiang.system.dao.CityMapper;
import com.qianjiang.system.service.CityService;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.system.vo.CityVo;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="CityService")
public class CityServiceImpl
implements CityService {
    private CityMapper cityMapper;

    public CityMapper getCityMapper() {
        return this.cityMapper;
    }

    @Resource(name="CityMapper")
    public void setCityMapper(CityMapper cityMapper) {
        this.cityMapper = cityMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveCity(String cityName, String provinceId, String citySort) {
        City city = new City();
        try {
            if (null != cityName) {
                city.setCityName(cityName);
                city.setCitySort(citySort);
                city.setProvinceId(Long.parseLong(provinceId));
                city.setDelFlag("0");
                int n = this.cityMapper.insertSelective(city);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            city = null;
        }
    }

    @Override
    public int delPCity(Long cityId) {
        return this.cityMapper.deleteByPrimaryKey(cityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateCity(String cityId, String cityName, String citySort) {
        City city = new City();
        try {
            if (null != cityId) {
                city.setCityId(Long.parseLong(cityId));
                city.setCityName(cityName);
                city.setCitySort(citySort);
                int n = this.cityMapper.updateByPrimaryKeySelective(city);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            city = null;
        }
    }

    @Override
    public City findCityByPrimaryKey(Long cityId) {
        return this.cityMapper.selectByPrimaryKey(cityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean findListByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            pb.setRows(this.cityMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.cityMapper.queryCityListByPb(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public int batchDelCity(String[] cityIds) {
        int count = 0;
        if (null != cityIds && cityIds.length > 0) {
            for (int i = 0; i < cityIds.length; ++i) {
                count += this.delPCity(Long.parseLong(cityIds[i]));
            }
        }
        return count;
    }

    @Override
    public List<CityVo> queryCityByProvinceId(Long provinceId) {
        return this.cityMapper.queryCityByProvinceId(provinceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCityName(String cityName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("cityName", cityName);
            boolean bl = this.cityMapper.queryCityByCityName(map) <= 0;
            return bl;
        }
        finally {
            map = null;
        }
    }

    @Override
    public AddressUtil queryAddressNameByCityId(Long cityId) {
        return this.cityMapper.queryProvinceNameByCityId(cityId);
    }

    @Override
    public List<Object> queryCityByProvinceIdAndCityName(Long provinceId, String cityName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("provinceId", provinceId);
        paramMap.put("cityName", cityName);
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", 1000);
        return this.cityMapper.queryCityListByPb(paramMap);
    }

    @Override
    public int queryCityNameCount(City city) {
        return this.cityMapper.queryCityNameCount(city);
    }
}

