/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.ExpressConf;
import com.qianjiang.system.bean.LogisticsCompany;
import com.qianjiang.system.dao.IExpressConfDao;
import com.qianjiang.system.dao.ILogisticsCompanyDao;
import com.qianjiang.system.service.IExpressConfBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="expressConfBizImpl")
public class ExpressConfBizImpl
implements IExpressConfBiz {
    private static final MyLogger LOGGER = new MyLogger(ExpressConfBizImpl.class);
    private static final String START_ROW_NUM = "startRowNum";
    private static final String END_ROW_NUM = "endRowNum";
    private IExpressConfDao expressConfDaoImpl;
    private ILogisticsCompanyDao logisticsCompanyDaoImpl;
    private static final int ENDROWNUM = 10000;

    public final IExpressConfDao getExpressConfDaoImpl() {
        return this.expressConfDaoImpl;
    }

    @Resource(name="expressConfDaoImpl")
    public final void setExpressConfDaoImpl(IExpressConfDao expressConfDaoImpl) {
        this.expressConfDaoImpl = expressConfDaoImpl;
    }

    @Override
    public final boolean saveExpressConf(ExpressConf expressConf) {
        if (expressConf == null) {
            LOGGER.error("\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff01");
            return false;
        }
        try {
            return this.expressConfDaoImpl.saveExpressConf(expressConf);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return false;
        }
    }

    @Override
    public final int updateExpressConf(ExpressConf expressConf) {
        if (expressConf == null) {
            LOGGER.error("\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff01");
            return 0;
        }
        try {
            return this.expressConfDaoImpl.updateExpressConf(expressConf);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public final ExpressConf getExpressConfById(int id) {
        if (id == 0) {
            LOGGER.error("\u5bf9\u8c61\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u7684id\u4e3a0\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return null;
        }
        try {
            return this.expressConfDaoImpl.getExpressConfById(id);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
    }

    @Override
    public final List<ExpressConf> getExpressConfByIds(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return Collections.emptyList();
        }
        try {
            return this.expressConfDaoImpl.getExpressConfByIds(ids);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return Collections.emptyList();
        }
    }

    @Override
    public final int deleteExpressConf(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return 0;
        }
        try {
            return this.expressConfDaoImpl.deleteExpressConf(ids);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public final int updateExpressConfFieldById(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u66f4\u65b0\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\uff01");
            return 0;
        }
        if (parameter.containsKey("ids")) {
            String ids = (String)parameter.get("ids");
            ArrayList<String> idList = new ArrayList<String>();
            if (ids.contains(",")) {
                for (String id : ids.split(",")) {
                    idList.add(id);
                }
            } else {
                idList.add(ids);
            }
            parameter.put("ids", idList);
        }
        try {
            return this.expressConfDaoImpl.updateExpressConfFieldById(parameter);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public final int getExpressConfByFieldTotal(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.expressConfDaoImpl.getExpressConfByFieldTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public final PageBean getExpressConfByField(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.getExpressConfByFieldTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put(START_ROW_NUM, pageBean.getStartRowNum());
            parameter.put(END_ROW_NUM, pageBean.getEndRowNum());
            pageBean.setList(this.expressConfDaoImpl.getExpressConfByField(parameter));
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
        return pageBean;
    }

    @Override
    public final ExpressConf getExpressConfByUsedField() {
        return this.expressConfDaoImpl.getExpressConfByUsedField();
    }

    @Override
    public final int queryExpressConfTotal(Map<String, Object> parameter) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.expressConfDaoImpl.queryExpressConfTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public final PageBean queryExpressConfByPage(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5206\u9875\u67e5\u8be2\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.queryExpressConfTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put(START_ROW_NUM, pageBean.getStartRowNum());
            parameter.put(END_ROW_NUM, pageBean.getEndRowNum());
            pageBean.setList(this.expressConfDaoImpl.queryExpressConfByPage(parameter));
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
        return pageBean;
    }

    @Override
    public Map<String, Object> queryAllExpress() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(START_ROW_NUM, 0);
        map.put(END_ROW_NUM, 10000);
        map.put("deleteStatus", 0);
        map.put("usedStatus", 1);
        map.put("expresss", this.expressConfDaoImpl.getExpressConfByField(map));
        map.put("expressCompany", this.logisticsCompanyDaoImpl.getLogisticsCompanyByField(map));
        return map;
    }

    @Override
    public String queryKuaidi100CodeByExpressId(Long expressid) {
        return this.expressConfDaoImpl.queryKuaidi100CodeByExpressId(expressid);
    }

    @Override
    public boolean changeUserdStatus(Long expressid) {
        ExpressConf express = this.expressConfDaoImpl.getExpressConfById(expressid.intValue());
        if ("0".equals(express.getUsedStatus())) {
            express.setUsedStatus("1");
        } else {
            express.setUsedStatus("0");
        }
        return this.expressConfDaoImpl.updateExpressConf(express) > 0;
    }

    @Override
    public LogisticsCompany getLogisticsByExpressId(Long expressId) {
        try {
            Integer logistId = this.expressConfDaoImpl.getExpressConfById(expressId.intValue()).getExpress();
            return this.logisticsCompanyDaoImpl.getLogisticsCompanyById(logistId);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u914d\u9001\u65b9\u5f0f\u83b7\u53d6\u7269\u6d41\u516c\u53f8\u9519\u8bef\uff1a=>", e);
            return null;
        }
    }

    @Override
    public int deleteOneExpressConf(Integer expressId) {
        ExpressConf expressConf = new ExpressConf();
        expressConf.setExpressId(expressId);
        expressConf.setDeleteStatus(1);
        this.expressConfDaoImpl.updateExpressConf(expressConf);
        return 1;
    }

    public final ILogisticsCompanyDao getLogisticsCompanyDaoImpl() {
        return this.logisticsCompanyDaoImpl;
    }

    @Resource(name="logisticsCompanyDaoImpl")
    public final void setLogisticsCompanyDaoImpl(ILogisticsCompanyDao logisticsCompanyDaoImpl) {
        this.logisticsCompanyDaoImpl = logisticsCompanyDaoImpl;
    }
}

