/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.bean.HelpCate;
import com.qianjiang.system.dao.HelpCateMapper;
import com.qianjiang.system.dao.HelpCenterMapper;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="helpCateService")
public class HelpCateServiceImpl
implements HelpCateService {
    @Resource(name="helpCateMapper")
    private HelpCateMapper helpCateMapper;
    @Resource(name="helpCenterMapper")
    private HelpCenterMapper helpCenterMapper;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public PageBean findByPageBean(PageBean pb, SelectBean selectBean) {
        pb.setRows(this.helpCateMapper.findTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        pb.setList(this.helpCateMapper.findByPageBean(map));
        return pb;
    }

    @Override
    public int insertHelpCate(HelpCate helpCate) {
        helpCate.setDelFlag("0");
        this.redisAdapter.delete("HELPCATELIST_KEY");
        return this.helpCateMapper.insertSelective(helpCate);
    }

    @Override
    public int deleteHelpCate(String[] helpcateId) {
        int count = 0;
        if (helpcateId != null) {
            for (String id : helpcateId) {
                count += this.helpCenterMapper.deleteByHelpCateId(Long.parseLong(id));
                count += this.helpCateMapper.deleteByPrimaryKey(Long.parseLong(id));
            }
        }
        this.redisAdapter.delete("HELPCATELIST_KEY");
        return count;
    }

    @Override
    public HelpCate findByHelpcateId(Long helpcateId) {
        return this.helpCateMapper.selectByPrimaryKey(helpcateId);
    }

    @Override
    public List<HelpCate> findByHelpcateName(String helpcateName) {
        return this.helpCateMapper.selectByPrimaryName(helpcateName);
    }

    @Override
    public int updateHelpCate(HelpCate helpCate) {
        helpCate.setModifyTime(new Date());
        this.redisAdapter.delete("HELPCATELIST_KEY");
        return this.helpCateMapper.updateByPrimaryKeySelective(helpCate);
    }

    @Override
    public List<HelpCate> findAll() {
        return this.helpCateMapper.findAll();
    }
}

