/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.LogisticsCompany;
import com.qianjiang.system.dao.IExpressConfDao;
import com.qianjiang.system.dao.ILogisticsCompanyDao;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="logisticsCompanyBizImpl")
public class LogisticsCompanyBizImpl
implements ILogisticsCompanyBiz {
    @Resource(name="logisticsCompanyDaoImpl")
    private ILogisticsCompanyDao logisticsCompanyDaoImpl;
    @Resource(name="expressConfDaoImpl")
    private IExpressConfDao expressConfDao;
    private static final MyLogger LOGGER = new MyLogger(LogisticsCompanyBizImpl.class);

    @Override
    public final boolean saveLogisticsCompany(LogisticsCompany logisticsCompany) {
        if (logisticsCompany == null) {
            LOGGER.error("\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff01");
            return false;
        }
        try {
            return this.logisticsCompanyDaoImpl.saveLogisticsCompany(logisticsCompany);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return false;
        }
    }

    @Override
    public final int updateLogisticsCompany(LogisticsCompany logisticsCompany) {
        if (logisticsCompany == null) {
            LOGGER.error("\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff01");
            return 0;
        }
        try {
            return this.logisticsCompanyDaoImpl.updateLogisticsCompany(logisticsCompany);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final LogisticsCompany getLogisticsCompanyById(int id) {
        if (id == 0) {
            LOGGER.error("\u5bf9\u8c61\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u7684id\u4e3a0\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return null;
        }
        try {
            return this.logisticsCompanyDaoImpl.getLogisticsCompanyById(id);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
    }

    @Override
    public final LogisticsCompany getThirdLogisticsCompanyById(int id) {
        if (id == 0) {
            LOGGER.error("\u5bf9\u8c61\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u7684id\u4e3a0\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return null;
        }
        try {
            return this.logisticsCompanyDaoImpl.getThirdLogisticsCompanyById(id);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
    }

    @Override
    public final List<LogisticsCompany> getLogisticsCompanyByIds(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return Collections.emptyList();
        }
        try {
            return this.logisticsCompanyDaoImpl.getLogisticsCompanyByIds(ids);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return Collections.emptyList();
        }
    }

    @Override
    public final int deleteLogisticsCompany(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return 0;
        }
        try {
            return this.logisticsCompanyDaoImpl.deleteLogisticsCompany(ids);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final int updateLogisticsCompanyFieldById(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u66f4\u65b0\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\uff01");
            return 0;
        }
        if (parameter.containsKey("ids")) {
            String ids = (String)parameter.get("ids");
            ArrayList<String> idList = new ArrayList<String>();
            if (ids.contains(",")) {
                for (String id : ids.split(",")) {
                    idList.add(id);
                }
            } else {
                idList.add(ids);
            }
            parameter.put("ids", idList);
        }
        try {
            return this.logisticsCompanyDaoImpl.updateLogisticsCompanyFieldById(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final int getLogisticsCompanyByFieldTotal(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.logisticsCompanyDaoImpl.getLogisticsCompanyByFieldTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final PageBean getLogisticsCompanyByField(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.getLogisticsCompanyByFieldTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.logisticsCompanyDaoImpl.getLogisticsCompanyByField(parameter));
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
        return pageBean;
    }

    @Override
    public final int queryLogisticsCompanyTotal(Map<String, Object> parameter) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.logisticsCompanyDaoImpl.queryLogisticsCompanyTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final PageBean queryLogisticsCompanyByPage(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5206\u9875\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.queryLogisticsCompanyTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.logisticsCompanyDaoImpl.queryLogisticsCompanyByPage(parameter));
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
        return pageBean;
    }

    @Override
    public int getLogisticsCompanyMaxSort() {
        try {
            return this.logisticsCompanyDaoImpl.getLogisticsCompanyMaxSort();
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public boolean changeUserdStatus(Long logComId) {
        LogisticsCompany logcom = this.logisticsCompanyDaoImpl.getLogisticsCompanyById(logComId.intValue());
        if ("0".equals(logcom.getUsedStatus())) {
            logcom.setUsedStatus("1");
        } else {
            logcom.setUsedStatus("0");
        }
        return this.logisticsCompanyDaoImpl.updateLogisticsCompany(logcom) > 0;
    }

    @Override
    public boolean checkDeleteLogistics(Long logComId) {
        return this.expressConfDao.queryExpressCountByLogistics(logComId) <= 0;
    }

    @Override
    public List<LogisticsCompany> queryAllLogisticsCompany() {
        return this.logisticsCompanyDaoImpl.queryAllLogisticsCompany();
    }

    @Override
    public void deleteLogisticsCompanyOne(Integer logComId) {
        LogisticsCompany company = new LogisticsCompany();
        company.setLogComId(logComId);
        company.setDeleteStatus(1);
        this.logisticsCompanyDaoImpl.updateLogisticsCompany(company);
    }

    @Override
    public List<LogisticsCompany> queryLogisticsCompanys() {
        return this.logisticsCompanyDaoImpl.queryLogisticsCompanys();
    }
}

