/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.dao.PayMapper;
import com.qianjiang.system.service.PayService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Service;

@Service(value="payService")
public class PayServiceImpl
implements PayService {
    private static final MyLogger LOGGER = new MyLogger(PayServiceImpl.class);
    private String zero = "0";
    private String one = "1";
    private static final int ENDROWNUMS = 10000;
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private static final String CONDITION = "condition";
    @Resource(name="payMapper")
    private PayMapper payMapper;

    @Override
    public void deletePaySetById(Long payId) {
        this.payMapper.deleteByPrimaryKey(payId);
    }

    @Override
    public PageBean findByPageBean(PageBean pageBean, SelectBean selectBean) {
        pageBean.setRows(this.payMapper.findTotalCount(selectBean));
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put(STARTROWNUM, pageBean.getStartRowNum());
        maps.put(ENDROWNUM, pageBean.getEndRowNum());
        maps.put(CONDITION, selectBean.getCondition());
        maps.put("searchText", selectBean.getSearchText());
        pageBean.setList(this.payMapper.findByPageBean(maps));
        return pageBean;
    }

    @Override
    public int insertPay(Pay pay) {
        Pay pa;
        pay.setDelFlag(this.zero);
        if (pay.getPayDefault().equals(this.one) && (pa = this.payMapper.selectByDefault(this.one)) != null) {
            pa.setPayDefault(this.zero);
            this.payMapper.updateByPrimaryKeySelective(pa);
        }
        return this.payMapper.insertSelective(pay);
    }

    @Override
    public int deletePay(String[] payIds) {
        int count = 0;
        for (String id : payIds) {
            count += this.payMapper.deleteByPrimaryKey(Long.parseLong(id));
        }
        return count;
    }

    @Override
    public Pay findByPayId(Long payId) {
        return this.payMapper.selectByPrimaryKey(payId);
    }

    @Override
    public Map updatePay(Pay pay) {
        String msg;
        int result;
        HashedMap resultMap;
        block13: {
            resultMap = new HashedMap();
            result = 0;
            msg = "\u4fee\u6539\u6210\u529f";
            pay.setModifyTime(new Date());
            try {
                List<Pay> openList = this.payMapper.selectOpenList(this.one);
                if (pay.getIsOpen().equals(this.zero)) {
                    if (openList != null && openList.size() == 1) {
                        msg = "\u5fc5\u987b\u542f\u7528\u4e00\u4e2a\u652f\u4ed8\u65b9\u5f0f";
                        break block13;
                    }
                    pay.setPayDefault(this.zero);
                    Pay payDefault = this.payMapper.selectByDefault(this.one);
                    if (payDefault != null) {
                        if (pay.getPayId() == payDefault.getPayId()) {
                            for (Pay payOpen : openList) {
                                if (payOpen.getPayId() == pay.getPayId()) continue;
                                payOpen.setPayDefault(this.one);
                                result = this.payMapper.updateByPrimaryKeySelective(payOpen);
                                result = this.payMapper.updateByPrimaryKeySelective(pay);
                                break block13;
                            }
                            break block13;
                        }
                        result = this.payMapper.updateByPrimaryKeySelective(pay);
                        break block13;
                    }
                    msg = "\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u7684\u652f\u4ed8\u65b9\u5f0f";
                    break block13;
                }
                if (pay.getPayDefault().equals(this.one)) {
                    Pay pa = this.payMapper.selectByDefault(this.one);
                    if (pa != null) {
                        pa.setPayDefault(this.zero);
                        result = this.payMapper.updateByPrimaryKeySelective(pa);
                    }
                    result = this.payMapper.updateByPrimaryKeySelective(pay);
                    break block13;
                }
                if (openList != null && openList.size() == 1) {
                    msg = "\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u7684\u652f\u4ed8\u65b9\u5f0f";
                    break block13;
                }
                pay.setPayDefault(this.zero);
                Pay payDefault = this.payMapper.selectByDefault(this.one);
                if (payDefault != null) {
                    if (pay.getPayId() == payDefault.getPayId()) {
                        for (Pay payOpen : openList) {
                            if (payOpen.getPayId() == pay.getPayId()) continue;
                            payOpen.setPayDefault(this.one);
                            result = this.payMapper.updateByPrimaryKeySelective(payOpen);
                            result = this.payMapper.updateByPrimaryKeySelective(pay);
                            break block13;
                        }
                        break block13;
                    }
                    result = this.payMapper.updateByPrimaryKeySelective(pay);
                    break block13;
                }
                msg = "\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u7684\u652f\u4ed8\u65b9\u5f0f";
            }
            catch (Exception e) {
                LOGGER.error("\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef\uff1a", e);
            }
        }
        resultMap.put("result", result);
        resultMap.put("msg", msg);
        return resultMap;
    }

    @Override
    public List<Object> queryAllPaySet() {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put(STARTROWNUM, 0);
        maps.put(ENDROWNUM, 10000);
        maps.put(CONDITION, -1);
        List<Object> objectList = this.payMapper.findByPageBean(maps);
        Collections.sort(objectList, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Pay)o1).getPayDefault().compareTo(((Pay)o2).getPayDefault());
            }
        });
        Collections.reverse(objectList);
        return objectList;
    }

    @Override
    public boolean updateUserdStatus(Long payId) {
        Pay pay = this.payMapper.selectByPrimaryKey(payId);
        if ("0".equals(pay.getIsOpen())) {
            pay.setIsOpen("1");
        } else {
            pay.setIsOpen("0");
        }
        pay.setModifyTime(new Date());
        return this.payMapper.updateByPrimaryKeySelective(pay) > 0;
    }

    @Override
    public boolean changeDefault(Long payId) {
        try {
            this.payMapper.changeDefaultToNO(payId);
            Pay pay = this.payMapper.selectByPrimaryKey(payId);
            pay.setPayDefault("1");
            pay.setModifyTime(new Date());
            return this.payMapper.updateByPrimaryKeySelective(pay) > 0;
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9ed8\u8ba4\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef\uff1a=>", e);
            return false;
        }
    }

    @Override
    public PageBean findPayByPayType(PageBean pageBean, SelectBean selectBean) {
        pageBean.setRows(this.payMapper.findTotalCountByPayType(selectBean));
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put(STARTROWNUM, pageBean.getStartRowNum());
        maps.put(ENDROWNUM, pageBean.getEndRowNum());
        maps.put(CONDITION, selectBean.getCondition());
        maps.put("searchText", selectBean.getSearchText());
        pageBean.setList(this.payMapper.findPayByPayType(maps));
        return pageBean;
    }

    @Override
    public int updatePayHelp(Pay pay) {
        return this.payMapper.upadtePayHelp(pay);
    }

    @Override
    public List<Pay> selectMobilePay() {
        return this.payMapper.selectMobilePay();
    }

    @Override
    public Pay selectWxPay() {
        return this.payMapper.selectWxPay();
    }

    @Override
    public Pay selectPayByType(String type) {
        return this.payMapper.selectPayByType(type);
    }
}

