/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.Province;
import com.qianjiang.system.dao.ProvinceMapper;
import com.qianjiang.system.service.ProvinceService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ProvinceService")
public class ProvinceServiceImpl
implements ProvinceService {
    private static final String SEARCHTEXT = "searchText";
    private ProvinceMapper provinceMapper;
    private static final int ENDROWNUM = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveProvince(String provinceName, String provinceSort) {
        Province province = new Province();
        try {
            if (null != provinceName) {
                province.setProvinceName(provinceName);
                province.setProvinceSort(provinceSort);
                province.setDelFlag("0");
                int n = this.provinceMapper.insertSelective(province);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            province = null;
        }
    }

    @Override
    public int delProvince(Long provinceId) {
        return this.provinceMapper.deleteByPrimaryKey(provinceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateProvince(String provinceId, String provinceName, String provinceSort) {
        Province province = new Province();
        try {
            if (null != provinceId) {
                province.setProvinceId(Long.parseLong(provinceId));
                province.setProvinceName(provinceName);
                province.setProvinceSort(provinceSort);
                int n = this.provinceMapper.updateByPrimaryKeySelective(province);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            province = null;
        }
    }

    @Override
    public Province findProvinceByPrimaryKey(Long provinceId) {
        return this.provinceMapper.selectByPrimaryKey(provinceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean findListByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> limitmap = new HashMap<String, Object>();
        try {
            limitmap.put("condition", selectBean.getCondition());
            limitmap.put(SEARCHTEXT, selectBean.getSearchText());
            pb.setRows(this.provinceMapper.queryTotalCount(limitmap));
            limitmap.put("startRowNum", pb.getStartRowNum());
            limitmap.put("endRowNum", 10000);
            pb.setList(this.provinceMapper.queryAllProvice(limitmap));
        }
        finally {
            limitmap = null;
        }
        return pb;
    }

    @Override
    public int batchDelProvince(String[] provinceIds) {
        Integer count = 0;
        if (null != provinceIds && provinceIds.length > 0) {
            for (int i = 0; i < provinceIds.length; ++i) {
                count = this.delProvince(Long.parseLong(provinceIds[i]));
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkProvinceName(String provinceName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("provinceName", provinceName);
            boolean bl = this.provinceMapper.queryProvinceByName(map) <= 0;
            return bl;
        }
        finally {
            map = null;
        }
    }

    @Override
    public List<Object> queryAllProvince() {
        return this.provinceMapper.queryAllProvince();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean findListByPageBeanNew(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> limitmap = new HashMap<String, Object>();
        try {
            limitmap.put(SEARCHTEXT, selectBean.getSearchText());
            pb.setList(this.provinceMapper.queryAllProviceNew(limitmap));
        }
        finally {
            limitmap = null;
        }
        return pb;
    }

    @Override
    public List<Object> queryAllProvinceByName(String provinceName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(SEARCHTEXT, provinceName);
        paramMap.put("condition", "1");
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", 1000);
        return this.provinceMapper.queryAllProvice(paramMap);
    }

    @Override
    public int queryProvinceNameCount(String provinceName) {
        return this.provinceMapper.queryProvinceNameCount(provinceName);
    }

    public ProvinceMapper getProvinceMapper() {
        return this.provinceMapper;
    }

    @Resource(name="ProvinceMapper")
    public void setProvinceMapper(ProvinceMapper provinceMapper) {
        this.provinceMapper = provinceMapper;
    }
}

