/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.GoodsCateSystem;
import com.qianjiang.system.bean.Storey;
import com.qianjiang.system.dao.StoreyMapper;
import com.qianjiang.system.service.StoreyService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="storeyService")
public class StoreyServiceImpl
implements StoreyService {
    @Resource(name="storeyMapper")
    private StoreyMapper storeyMapper;

    @Override
    public PageBean findByPageBean(PageBean pageBean, SelectBean selectBean) {
        pageBean.setRows(this.storeyMapper.findTotalCount(selectBean));
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("startRowNum", pageBean.getStartRowNum());
        maps.put("endRowNum", pageBean.getEndRowNum());
        maps.put("condition", selectBean.getCondition());
        maps.put("searchText", selectBean.getSearchText());
        pageBean.setList(this.storeyMapper.findByPageBean(maps));
        return pageBean;
    }

    @Override
    public List<GoodsCateSystem> findParentGoodsCate() {
        return this.storeyMapper.findParentGoodsCate();
    }

    @Override
    public int insertStorey(Storey storey) {
        storey.setDelFlag("0");
        return this.storeyMapper.insertSelective(storey);
    }

    @Override
    public Storey findStoreyByFloorId(Long floorId) {
        return this.storeyMapper.findStoreyByFloorId(floorId);
    }

    @Override
    public int deleteStorey(String[] seIds) {
        int count = 0;
        if (seIds != null) {
            for (String id : seIds) {
                count += this.storeyMapper.deleteByPrimaryKey(Long.parseLong(id));
            }
        }
        return count;
    }

    @Override
    public Storey findStoreyById(Long seId) {
        return this.storeyMapper.selectByPrimaryKey(seId);
    }

    @Override
    public int updateStorey(Storey storey) {
        storey.setModifyTime(new Date());
        return this.storeyMapper.updateByPrimaryKeySelective(storey);
    }
}

