/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.Street;
import com.qianjiang.system.dao.StreetMapper;
import com.qianjiang.system.service.StreetService;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository(value="StreetService")
public class StreetServiceImpl
implements StreetService {
    private StreetMapper streetMapper;

    public StreetMapper getStreetMapper() {
        return this.streetMapper;
    }

    @Resource(name="StreetMapper")
    public void setStreetMapper(StreetMapper streetMapper) {
        this.streetMapper = streetMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveStreet(String streetName, String districtId, String streetSort) {
        Street street = new Street();
        try {
            if (null != streetName) {
                street.setStreetName(streetName);
                street.setStreetSort(streetSort);
                street.setDistrictId(Long.parseLong(districtId));
                street.setDelFlag("0");
                int n = this.streetMapper.insertSelective(street);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            street = null;
        }
    }

    @Override
    public int delStreet(Long streetId) {
        return this.streetMapper.deleteByPrimaryKey(streetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateStreet(String streetId, String streetName, String streetSort) {
        Street street = new Street();
        try {
            if (null != streetId) {
                street.setStreetId(Long.parseLong(streetId));
                street.setStreetName(streetName);
                street.setStreetSort(streetSort);
                int n = this.streetMapper.updateByPrimaryKeySelective(street);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            street = null;
        }
    }

    @Override
    public Street findStreetByPrimaryKey(Long streetId) {
        return this.streetMapper.selectByPrimaryKey(streetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean findListByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            pb.setRows(this.streetMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.streetMapper.queryAllStreetByPb(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public int batchDelStreet(String[] streetIds) {
        int count = 0;
        if (null != streetIds && streetIds.length > 0) {
            for (int i = 0; i < streetIds.length; ++i) {
                count += this.delStreet(Long.parseLong(streetIds[i]));
            }
        }
        return count;
    }

    @Override
    public List<Street> queryStreetByDistrictId(Long districtId) {
        return this.streetMapper.queryStreetByDistrictId(districtId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkStreetName(String streetName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("streetName", streetName);
            boolean bl = this.streetMapper.queryStreetByStreetName(map) <= 0;
            return bl;
        }
        finally {
            map = null;
        }
    }

    @Override
    public AddressUtil queryAddressNameByStreetId(Long streetId) {
        return this.streetMapper.queryAddressNameByStreetId(streetId);
    }

    @Override
    public List<Object> queryStreetByDistrictIdAndStreetName(Long districtId, String streetName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("districtId", districtId);
        paramMap.put("streetName", streetName);
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", 1000);
        return this.streetMapper.queryAllStreetByPb(paramMap);
    }
}

