/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.service.impl;

import com.qianjiang.channel.bean.GoodsCate;
import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.temp.bean.ClassifyBar;
import com.qianjiang.temp.bean.ClassifyBarCate;
import com.qianjiang.temp.bean.ClassifyBarQuick;
import com.qianjiang.temp.dao.ClassifyBarCateMapper;
import com.qianjiang.temp.dao.ClassifyBarMapper;
import com.qianjiang.temp.dao.ClassifyBarQuickMapper;
import com.qianjiang.temp.service.ClassifyBarService;
import com.qianjiang.temp.vo.ClassifyBarVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ClassifyBarService")
public class ClassifyBarServiceImpl
implements ClassifyBarService {
    private static final MyLogger LOGGER = new MyLogger(ClassifyBarServiceImpl.class);
    private static final String TEMP1 = "temp1";
    @Resource(name="ClassifyBarMapper")
    private ClassifyBarMapper classifyBarMapper;
    @Resource(name="ClassifyBarCateMapper")
    private ClassifyBarCateMapper barCateMapper;
    @Resource(name="ClassifyBarQuickMapper")
    private ClassifyBarQuickMapper barQuickMapper;
    @Resource(name="ChannelGoodsCateService")
    private GoodsCateService goodsCateService;

    @Override
    public int deleteClassifyBar(Long classifyBarId) {
        try {
            return this.classifyBarMapper.deleteByPrimaryKey(classifyBarId);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5206\u7c7b\u5bfc\u822a\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int saveClassifyBar(ClassifyBar record) {
        try {
            if (record.getTemp1() == null && record.getGoodsCatId() > -1L) {
                GoodsCate cate = this.goodsCateService.selectGoosCateById(record.getGoodsCatId());
                if (record.getGrade() == 2) {
                    String cateOne = cate.getCatParentId().toString();
                    record.setTemp3(cateOne);
                    List<GoodsCate> list = this.goodsCateService.queryGoosCateByParentId(cate.getCatId());
                    if (!list.isEmpty()) {
                        String cateThird = list.get(0).getCatId().toString();
                        record.setTemp4(cateThird);
                    } else {
                        record.setTemp4(cate.getCatId().toString());
                    }
                } else if (record.getGrade() == 3) {
                    String cateOne = this.goodsCateService.selectGoosCateById(cate.getCatParentId()).getCatParentId().toString();
                    record.setTemp3(cateOne);
                }
            }
            Date date = new Date();
            record.setCreateDate(date);
            record.setUpdateDate(date);
            record.setDelflag("0");
            return this.classifyBarMapper.insertSelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5206\u7c7b\u5bfc\u822a\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public int updateClassifyBar(ClassifyBar record) {
        try {
            if (record.getTemp1() == null && record.getGoodsCatId() > -1L) {
                GoodsCate cate = this.goodsCateService.selectGoosCateById(record.getGoodsCatId());
                if (record.getGrade() == 2) {
                    String cateOne = cate.getCatParentId().toString();
                    record.setTemp3(cateOne);
                    List<GoodsCate> list = this.goodsCateService.queryGoosCateByParentId(cate.getCatId());
                    if (!list.isEmpty()) {
                        String cateThird = list.get(0).getCatId().toString();
                        record.setTemp4(cateThird);
                    } else {
                        record.setTemp4(cate.getCatId().toString());
                    }
                } else if (record.getGrade() == 3) {
                    String cateOne = this.goodsCateService.selectGoosCateById(cate.getCatParentId()).getCatParentId().toString();
                    record.setTemp3(cateOne);
                }
            }
            record.setUpdateDate(new Date());
            return this.classifyBarMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5206\u7c7b\u5bfc\u822a\u9519\u8bef:", e);
            return 0;
        }
    }

    @Override
    public ClassifyBar getClassifyBarById(Long classifyBarId) {
        ClassifyBar classifyBar = null;
        try {
            classifyBar = this.classifyBarMapper.selectByPrimaryKey(classifyBarId);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636eID\u67e5\u8be2\u5206\u7c7b\u5bfc\u822a\u9519\u8bef:", e);
        }
        return classifyBar;
    }

    @Override
    public PageBean selectClassifyBarByParam(PageBean pb, Long tempId, Long channelId, String thirdId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("channelId", channelId);
            map.put("tempId", tempId);
            map.put(TEMP1, thirdId);
            pb.setRows(this.classifyBarMapper.selectClassifyBarCountByParam(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.classifyBarMapper.selectClassifyBarByParam(map));
            return pb;
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u5206\u7c7b\u5bfc\u822a\u5217\u8868\u9519\u8bef:", e);
            return null;
        }
    }

    @Override
    public List<ClassifyBarVo> selectClassifyBarByParamSite(Long tempId, Long channelId, String thirdId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("channelId", channelId);
            map.put("tempId", tempId);
            map.put(TEMP1, thirdId);
            return this.classifyBarMapper.selectClassifyBarByParamSite(map);
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u5206\u7c7b\u5bfc\u822a\u5217\u8868\u9519\u8bef:", e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<ClassifyBarVo> selectClassifyBarByParamThirdSite(Long tempId, Long channelId, String thirdId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("channelId", channelId);
            map.put("tempId", tempId);
            map.put(TEMP1, thirdId);
            return this.classifyBarMapper.selectClassifyBarByParamThirdSite(map);
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u5206\u7c7b\u5bfc\u822a\u5217\u8868\u9519\u8bef:", e);
            return Collections.emptyList();
        }
    }

    @Override
    public int saveClassifyBarAndCateAndQuick(ClassifyBar record, List<ClassifyBarCate> barCates, List<ClassifyBarQuick> barQuicks) {
        int count = 0;
        try {
            count = this.classifyBarMapper.insertSelective(record);
            if (null != barCates && !barCates.isEmpty()) {
                for (ClassifyBarCate barCate : barCates) {
                    barCate.setClassifybarId(record.getClassifyBarId());
                    List<GoodsCate> twolist = this.goodsCateService.queryGoosCateByParentId(barCate.getCateId());
                    if (!twolist.isEmpty()) {
                        GoodsCate cateTwo = twolist.get(0);
                        List<GoodsCate> thirdlist = this.goodsCateService.queryGoosCateByParentId(cateTwo.getCatId());
                        if (!thirdlist.isEmpty()) {
                            GoodsCate cateThird = thirdlist.get(0);
                            barCate.setTemp1(cateThird.getCatId().toString());
                        } else {
                            barCate.setTemp1(cateTwo.getCatId().toString());
                        }
                    } else {
                        barCate.setTemp1(record.getClassifyBarId().toString());
                    }
                    barCate.setClassifybarId(record.getClassifyBarId());
                    this.barCateMapper.insertSelective(barCate);
                }
            }
            if (null != barQuicks && !barQuicks.isEmpty()) {
                for (ClassifyBarQuick barQuick : barQuicks) {
                    GoodsCate cate = this.goodsCateService.selectGoosCateById(barQuick.getCateId());
                    if (cate.getCatParentId() != null) {
                        Long cateId = this.goodsCateService.selectGoosCateById(cate.getCatParentId()).getCatParentId();
                        barQuick.setTemp1(cateId.toString());
                    }
                    barQuick.setClassifybarId(record.getClassifyBarId());
                    this.barQuickMapper.insertSelective(barQuick);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("", e);
            count = 0;
        }
        return count;
    }

    @Override
    public int updateClassifyBarAndCateAndQuick(ClassifyBar record, List<ClassifyBarCate> barCates, List<ClassifyBarQuick> barQuicks) {
        int count = 0;
        try {
            this.barCateMapper.batchDeleteByClassifyBarId(record.getClassifyBarId());
            this.barQuickMapper.batchDeleteByClassifyBarId(record.getClassifyBarId());
            count = this.classifyBarMapper.updateByPrimaryKeySelective(record);
            if (null != barCates && !barCates.isEmpty()) {
                for (ClassifyBarCate barCate : barCates) {
                    barCate.setClassifybarId(record.getClassifyBarId());
                    List<GoodsCate> twolist = this.goodsCateService.queryGoosCateByParentId(barCate.getCateId());
                    if (!twolist.isEmpty()) {
                        GoodsCate cateTwo = twolist.get(0);
                        List<GoodsCate> thirdlist = this.goodsCateService.queryGoosCateByParentId(cateTwo.getCatId());
                        if (!thirdlist.isEmpty()) {
                            GoodsCate cateThird = thirdlist.get(0);
                            barCate.setTemp1(cateThird.getCatId().toString());
                        } else {
                            barCate.setTemp1(cateTwo.getCatId().toString());
                        }
                    } else {
                        barCate.setTemp1(record.getClassifyBarId().toString());
                    }
                    barCate.setClassifybarId(record.getClassifyBarId());
                    this.barCateMapper.insertSelective(barCate);
                }
            }
            if (null != barQuicks && !barQuicks.isEmpty()) {
                for (ClassifyBarQuick barQuick : barQuicks) {
                    if (barQuick.getCateId() == 0L) {
                        barQuick.setTemp1(barQuick.getCateId().toString());
                    } else {
                        GoodsCate cate = this.goodsCateService.selectGoosCateById(barQuick.getCateId());
                        Long cateId = this.goodsCateService.selectGoosCateById(cate.getCatParentId()).getCatParentId();
                        barQuick.setTemp1(cateId.toString());
                    }
                    barQuick.setClassifybarId(record.getClassifyBarId());
                    this.barQuickMapper.insertSelective(barQuick);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("", e);
            count = 0;
        }
        return count;
    }

    @Override
    public int deleteClassifyBarAndCateAndQuick(Long classifyBarId) {
        int count = 0;
        try {
            count = this.classifyBarMapper.deleteByPrimaryKey(classifyBarId);
            this.barCateMapper.batchDeleteByClassifyBarId(classifyBarId);
            this.barQuickMapper.batchDeleteByClassifyBarId(classifyBarId);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            count = 0;
        }
        return count;
    }

    @Override
    public int deleteByPrimaryKeyAndPro(Long classifyBarId) {
        return this.classifyBarMapper.deleteByPrimaryKeyAndPro(classifyBarId);
    }

    @Override
    public int deleteClassBarById(Long classBarId, Long thirdId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("classifyBarId", classBarId);
            map.put(TEMP1, thirdId.toString());
            return this.classifyBarMapper.deleteClassBarById(map);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5206\u7c7b\u5bfc\u822a\u9519\u8bef:", e);
            return 0;
        }
    }
}

