/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.qianjiang.util.JsonDateValueProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.object.DateMorpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.util.JSONUtils;
import org.apache.log4j.Logger;

public class JsonUtil {
    private static final Logger LOGGER = Logger.getLogger(JsonUtil.class);

    private JsonUtil() {
    }

    public static Object getDTO(String jsonString, Class<?> clazz) {
        JSONObject jsonObject = null;
        try {
            JsonUtil.setDataFormat2JAVA();
            jsonObject = JSONObject.fromObject((Object)jsonString);
        }
        catch (Exception e) {
            LOGGER.error((Object)"JSON\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
        }
        return JSONObject.toBean((JSONObject)jsonObject, clazz);
    }

    public static Object getDTO(String jsonString, Class<?> clazz, Map<?, ?> map) {
        JSONObject jsonObject = null;
        try {
            JsonUtil.setDataFormat2JAVA();
            jsonObject = JSONObject.fromObject((Object)jsonString);
        }
        catch (Exception e) {
            LOGGER.error((Object)"JSON\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
        }
        return JSONObject.toBean((JSONObject)jsonObject, clazz, map);
    }

    public static Object[] getDTOArray(String jsonString, Class<?> clazz) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        Object[] obj = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            obj[i] = JSONObject.toBean((JSONObject)jsonObject, clazz);
        }
        return obj;
    }

    public static Object[] getDTOArray(String jsonString, Class<?> clazz, Map<?, ?> map) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        Object[] obj = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            obj[i] = JSONObject.toBean((JSONObject)jsonObject, clazz, map);
        }
        return obj;
    }

    public static <T> List<T> getDTOList(String jsonString, Class<T> clazz) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JSONObject jsonObject : array) {
            list.add(JSONObject.toBean((JSONObject)jsonObject, clazz));
        }
        return list;
    }

    public static List<Object> getDTOList(String jsonString, Class<?> clazz, Map<?, ?> map) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JSONObject jsonObject : array) {
            list.add(JSONObject.toBean((JSONObject)jsonObject, clazz, map));
        }
        return list;
    }

    public static Map<String, Object> getMapFromJson(String jsonString) {
        JsonUtil.setDataFormat2JAVA();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            map.put(key, jsonObject.get(key));
        }
        return map;
    }

    public static Object[] getObjectArrayFromJson(String jsonString) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        return jsonArray.toArray();
    }

    public static String getJSONString(Object object) {
        String jsonString = null;
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new JsonDateValueProcessor());
        jsonConfig.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
        if (object != null) {
            jsonString = object instanceof Collection || object instanceof Object[] ? JSONArray.fromObject((Object)object, (JsonConfig)jsonConfig).toString() : JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig).toString();
        }
        return jsonString == null ? "{}" : jsonString;
    }

    private static void setDataFormat2JAVA() {
        JSONUtils.getMorpherRegistry().registerMorpher((Morpher)new DateMorpher(new String[]{"yyyy-MM-dd HH:mm:ss"}));
    }
}

