/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.qianjiang.util.MyLogger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MapUtil {
    public static final MyLogger LOGGER = new MyLogger(MapUtil.class);

    private MapUtil() {
    }

    public static Map<String, Object> getParamsMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> clazz = bean.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                String fieldName = fields[i].getName();
                String getterMethodName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1, fieldName.length());
                try {
                    Method method = clazz.getMethod(getterMethodName, new Class[0]);
                    if (method == null) continue;
                    map.put(fieldName, method.invoke(bean, new Object[0]));
                    continue;
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("", e);
                    map = null;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("", e);
                    map = null;
                    continue;
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("", e);
                    map = null;
                    continue;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("", e);
                    map = null;
                    continue;
                }
                catch (SecurityException e) {
                    LOGGER.error("", e);
                    map = null;
                }
            }
        }
        return map;
    }

    public static Map<String, Object> getJsonMap(List<?> resultList, long resultCount) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("total", resultCount);
        jsonMap.put("rows", resultList);
        return jsonMap;
    }
}

